/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.GenerationUsage;
import com.alibaba.dashscope.aigc.generation.SearchInfo;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationUsage;
import com.alibaba.dashscope.common.DashScopeResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.tools.codeinterpretertool.ToolCallCodeInterpreter;
import com.alibaba.dashscope.tools.search.ToolCallQuarkSearch;
import com.google.gson.JsonObject;
import dev.langchain4j.community.model.dashscope.QwenHelper;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class QwenStreamingResponseBuilder {
    private final String modelName;
    private final boolean incrementalOutput;
    private GenerationResult accumulatedGenerationResult;
    private MultiModalConversationResult accumulatedMultiModalConversationResult;

    public QwenStreamingResponseBuilder(String modelName, boolean incrementalOutput) {
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.incrementalOutput = incrementalOutput;
    }

    public String append(GenerationResult partialResponse) {
        if (partialResponse == null) {
            return null;
        }
        String partialContent = null;
        if (QwenHelper.hasAnswer(partialResponse)) {
            partialContent = QwenHelper.answerFrom(partialResponse);
            if (!this.incrementalOutput && this.hasGenerationResult()) {
                String generatedContent = QwenHelper.answerFrom(this.accumulatedGenerationResult);
                partialContent = partialContent.substring(generatedContent.length());
            }
        }
        this.accumulatedGenerationResult = this.hasGenerationResult() ? this.mergeResult(this.accumulatedGenerationResult, partialResponse) : this.mergeResult(QwenStreamingResponseBuilder.newGenerationResult(), partialResponse);
        return partialContent;
    }

    public String append(MultiModalConversationResult partialResponse) {
        if (partialResponse == null) {
            return null;
        }
        String partialContent = null;
        if (QwenHelper.hasAnswer(partialResponse)) {
            partialContent = QwenHelper.answerFrom(partialResponse);
            if (!this.incrementalOutput && this.hasMultiModalConversationResult()) {
                String generatedContent = QwenHelper.answerFrom(this.accumulatedMultiModalConversationResult);
                partialContent = partialContent.substring(generatedContent.length());
            }
        }
        this.accumulatedMultiModalConversationResult = this.hasMultiModalConversationResult() ? this.mergeResult(this.accumulatedMultiModalConversationResult, partialResponse) : this.mergeResult(QwenStreamingResponseBuilder.newMultiModalConversationResult(), partialResponse);
        return partialContent;
    }

    public ChatResponse build() {
        if (this.hasGenerationResult()) {
            return QwenHelper.chatResponseFrom(this.modelName, this.accumulatedGenerationResult);
        }
        if (this.hasMultiModalConversationResult()) {
            return QwenHelper.chatResponseFrom(this.modelName, this.accumulatedMultiModalConversationResult);
        }
        return null;
    }

    private boolean hasGenerationResult() {
        return this.accumulatedGenerationResult != null;
    }

    private boolean hasMultiModalConversationResult() {
        return this.accumulatedMultiModalConversationResult != null;
    }

    private GenerationResult mergeResult(GenerationResult previous, GenerationResult current) {
        String requestId = (String)Utils.getOrDefault((Object)current.getRequestId(), (Object)previous.getRequestId());
        GenerationUsage usage = (GenerationUsage)Utils.getOrDefault((Object)current.getUsage(), (Object)previous.getUsage());
        GenerationOutput output = this.mergeOutput(previous.getOutput(), current.getOutput());
        GenerationResult result = QwenStreamingResponseBuilder.newGenerationResult();
        result.setRequestId(requestId);
        result.setUsage(usage);
        result.setOutput(output);
        return result;
    }

    private GenerationOutput mergeOutput(GenerationOutput previous, GenerationOutput current) {
        GenerationOutput output = new GenerationOutput();
        String finishReason = (String)Utils.getOrDefault((Object)current.getFinishReason(), (Object)previous.getFinishReason());
        String text = QwenStreamingResponseBuilder.merge(current.getText(), previous.getText());
        List<GenerationOutput.Choice> choices = this.mergeChoices(output, previous.getChoices(), current.getChoices());
        SearchInfo searchInfo = this.mergeSearchInfo(previous.getSearchInfo(), current.getSearchInfo());
        output.setFinishReason(finishReason);
        output.setText(text);
        output.setChoices(choices);
        output.setSearchInfo(searchInfo);
        return output;
    }

    private SearchInfo mergeSearchInfo(SearchInfo previous, SearchInfo current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        List searchResults = QwenStreamingResponseBuilder.merge(previous.getSearchResults(), current.getSearchResults());
        return SearchInfo.builder().searchResults(searchResults).build();
    }

    private List<GenerationOutput.Choice> mergeChoices(GenerationOutput output, List<GenerationOutput.Choice> previous, List<GenerationOutput.Choice> current) {
        ArrayList<GenerationOutput.Choice> choices = new ArrayList<GenerationOutput.Choice>(1);
        GenerationOutput.Choice lastPreviousChoice = null;
        if (!Utils.isNullOrEmpty(previous)) {
            lastPreviousChoice = previous.get(previous.size() - 1);
            if (previous.size() > 1) {
                choices.addAll(previous.subList(0, previous.size() - 1));
            }
        }
        if (!Utils.isNullOrEmpty(current)) {
            Iterator<GenerationOutput.Choice> iterator = current.iterator();
            GenerationOutput.Choice firstChoice = iterator.next();
            choices.add(this.mergeChoice(output, lastPreviousChoice, firstChoice));
            while (iterator.hasNext()) {
                choices.add(iterator.next());
            }
        } else if (lastPreviousChoice != null) {
            choices.add(lastPreviousChoice);
        }
        return choices;
    }

    private GenerationOutput.Choice mergeChoice(GenerationOutput output, GenerationOutput.Choice previous, GenerationOutput.Choice current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        Integer index = (Integer)Utils.getOrDefault((Object)current.getIndex(), (Object)previous.getIndex());
        String finishReason = (String)Utils.getOrDefault((Object)current.getFinishReason(), (Object)previous.getFinishReason());
        Message message = this.mergeMessage(previous.getMessage(), current.getMessage());
        GenerationOutput.Choice choice = new GenerationOutput.Choice(output);
        choice.setIndex(index);
        choice.setFinishReason(finishReason);
        choice.setMessage(message);
        return choice;
    }

    private Message mergeMessage(Message previous, Message current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        String content = this.mergeContent(previous.getContent(), current.getContent());
        String reasoningContent = QwenStreamingResponseBuilder.merge(previous.getReasoningContent(), current.getReasoningContent());
        String role = (String)Utils.getOrDefault((Object)current.getRole(), (Object)previous.getRole());
        role = (String)Utils.getOrDefault((Object)role, (Object)Role.ASSISTANT.getValue());
        String name = (String)Utils.getOrDefault((Object)current.getName(), (Object)previous.getName());
        List contents = QwenStreamingResponseBuilder.merge(previous.getContents(), current.getContents());
        List<ToolCallBase> toolCalls = this.mergeToolCalls(previous.getToolCalls(), current.getToolCalls());
        String toolCallId = (String)Utils.getOrDefault((Object)current.getToolCallId(), (Object)previous.getToolCallId());
        return Message.builder().content(content).contents(contents).toolCalls(toolCalls).toolCallId(toolCallId).name(name).role(role).reasoningContent(reasoningContent).build();
    }

    private String mergeContent(String previous, String current) {
        return this.incrementalOutput ? QwenStreamingResponseBuilder.merge(previous, current) : current;
    }

    private List<ToolCallBase> mergeToolCalls(List<ToolCallBase> previous, List<ToolCallBase> current) {
        ArrayList<ToolCallBase> toolCalls = new ArrayList<ToolCallBase>(1);
        ToolCallBase lastPreviousTooCall = null;
        if (!Utils.isNullOrEmpty(previous)) {
            lastPreviousTooCall = previous.get(previous.size() - 1);
            if (previous.size() > 1) {
                toolCalls.addAll(previous.subList(0, previous.size() - 1));
            }
        }
        if (!Utils.isNullOrEmpty(current)) {
            Iterator<ToolCallBase> iterator = current.iterator();
            ToolCallBase firstToolCall = iterator.next();
            if (Utils.isNotNullOrBlank((String)firstToolCall.getId())) {
                if (lastPreviousTooCall != null) {
                    toolCalls.add(lastPreviousTooCall);
                }
                toolCalls.add(firstToolCall);
            } else {
                toolCalls.add(this.mergeToolCall(lastPreviousTooCall, firstToolCall));
            }
            while (iterator.hasNext()) {
                toolCalls.add(iterator.next());
            }
        } else if (lastPreviousTooCall != null) {
            toolCalls.add(lastPreviousTooCall);
        }
        return toolCalls;
    }

    private ToolCallBase mergeToolCall(ToolCallBase previous, ToolCallBase current) {
        if (previous == null) {
            return current;
        }
        String id = Utils.isNotNullOrBlank((String)current.getId()) ? current.getId() : previous.getId();
        String type = (String)Utils.getOrDefault((Object)current.getType(), (Object)previous.getType());
        if (previous instanceof ToolCallFunction) {
            ToolCallFunction previousToolCallFunction = (ToolCallFunction)previous;
            if (current instanceof ToolCallFunction) {
                ToolCallFunction currentToolCallFunction = (ToolCallFunction)current;
                ToolCallFunction newToolCall = new ToolCallFunction();
                ToolCallFunction.CallFunction callFunction = this.mergeToolCallFunction(newToolCall, previousToolCallFunction.getFunction(), currentToolCallFunction.getFunction());
                newToolCall.setFunction(callFunction);
                newToolCall.setId(id);
                newToolCall.setType(type);
                return newToolCall;
            }
        }
        if (current instanceof ToolCallCodeInterpreter) {
            ToolCallCodeInterpreter newToolCall = new ToolCallCodeInterpreter();
            newToolCall.setId(id);
            newToolCall.setType(type);
            return newToolCall;
        }
        if (previous instanceof ToolCallQuarkSearch) {
            ToolCallQuarkSearch previousQuarkToolCall = (ToolCallQuarkSearch)previous;
            if (current instanceof ToolCallQuarkSearch) {
                ToolCallQuarkSearch currentQuarkToolCall = (ToolCallQuarkSearch)current;
                Map quarkSearch = QwenStreamingResponseBuilder.merge(previousQuarkToolCall.getQuarkSearch(), currentQuarkToolCall.getQuarkSearch());
                ToolCallQuarkSearch newToolCall = new ToolCallQuarkSearch();
                newToolCall.setId(id);
                newToolCall.setType(type);
                newToolCall.setQuarkSearch(quarkSearch);
                return newToolCall;
            }
        }
        return current;
    }

    private ToolCallFunction.CallFunction mergeToolCallFunction(ToolCallFunction toolCallFunction, ToolCallFunction.CallFunction previous, ToolCallFunction.CallFunction current) {
        if (previous == null) {
            return current;
        }
        String name = QwenStreamingResponseBuilder.merge(previous.getName(), current.getName());
        String arguments = QwenStreamingResponseBuilder.merge(previous.getArguments(), current.getArguments());
        String output = QwenStreamingResponseBuilder.merge(previous.getOutput(), current.getOutput());
        ToolCallFunction.CallFunction callFunction = new ToolCallFunction.CallFunction(toolCallFunction);
        callFunction.setName(name);
        callFunction.setArguments(arguments);
        callFunction.setOutput(output);
        return callFunction;
    }

    private MultiModalConversationResult mergeResult(MultiModalConversationResult previous, MultiModalConversationResult current) {
        String requestId = (String)Utils.getOrDefault((Object)current.getRequestId(), (Object)previous.getRequestId());
        MultiModalConversationUsage usage = (MultiModalConversationUsage)Utils.getOrDefault((Object)current.getUsage(), (Object)previous.getUsage());
        MultiModalConversationOutput output = this.mergeOutput(previous.getOutput(), current.getOutput());
        MultiModalConversationResult result = QwenStreamingResponseBuilder.newMultiModalConversationResult();
        result.setRequestId(requestId);
        result.setUsage(usage);
        result.setOutput(output);
        return result;
    }

    private MultiModalConversationOutput mergeOutput(MultiModalConversationOutput previous, MultiModalConversationOutput current) {
        List<MultiModalConversationOutput.Choice> choices = this.mergeChoices(previous.getChoices(), current.getChoices());
        MultiModalConversationOutput output = new MultiModalConversationOutput();
        output.setChoices(choices);
        return output;
    }

    private List<MultiModalConversationOutput.Choice> mergeChoices(List<MultiModalConversationOutput.Choice> previous, List<MultiModalConversationOutput.Choice> current) {
        ArrayList<MultiModalConversationOutput.Choice> choices = new ArrayList<MultiModalConversationOutput.Choice>(1);
        MultiModalConversationOutput.Choice lastPreviousChoice = null;
        if (!Utils.isNullOrEmpty(previous)) {
            lastPreviousChoice = previous.get(previous.size() - 1);
            if (previous.size() > 1) {
                choices.addAll(previous.subList(0, previous.size() - 1));
            }
        }
        if (!Utils.isNullOrEmpty(current)) {
            Iterator<MultiModalConversationOutput.Choice> iterator = current.iterator();
            MultiModalConversationOutput.Choice firstChoice = iterator.next();
            choices.add(this.mergeChoice(lastPreviousChoice, firstChoice));
            while (iterator.hasNext()) {
                choices.add(iterator.next());
            }
        } else if (lastPreviousChoice != null) {
            choices.add(lastPreviousChoice);
        }
        return choices;
    }

    private MultiModalConversationOutput.Choice mergeChoice(MultiModalConversationOutput.Choice previous, MultiModalConversationOutput.Choice current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        String finishReason = (String)Utils.getOrDefault((Object)current.getFinishReason(), (Object)previous.getFinishReason());
        MultiModalMessage message = this.mergeMessage(previous.getMessage(), current.getMessage());
        MultiModalConversationOutput.Choice choice = new MultiModalConversationOutput.Choice();
        choice.setFinishReason(finishReason);
        choice.setMessage(message);
        return choice;
    }

    private MultiModalMessage mergeMessage(MultiModalMessage previous, MultiModalMessage current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        List<Map<String, Object>> contents = this.mergeContents(previous.getContent(), current.getContent());
        String role = (String)Utils.getOrDefault((Object)current.getRole(), (Object)previous.getRole());
        role = (String)Utils.getOrDefault((Object)role, (Object)Role.ASSISTANT.getValue());
        return MultiModalMessage.builder().content(contents).role(role).build();
    }

    private List<Map<String, Object>> mergeContents(List<Map<String, Object>> previous, List<Map<String, Object>> current) {
        ArrayList<Map<String, Object>> contents = new ArrayList<Map<String, Object>>(1);
        Map<String, Object> lastPreviousContent = null;
        if (!Utils.isNullOrEmpty(previous)) {
            lastPreviousContent = previous.get(previous.size() - 1);
            if (previous.size() > 1) {
                contents.addAll(previous.subList(0, previous.size() - 1));
            }
        }
        if (!Utils.isNullOrEmpty(current)) {
            Iterator<Map<String, Object>> iterator = current.iterator();
            Map<String, Object> firstContent = iterator.next();
            contents.add(this.mergeContent(lastPreviousContent, firstContent));
            while (iterator.hasNext()) {
                contents.add(iterator.next());
            }
        } else if (lastPreviousContent != null) {
            contents.add(lastPreviousContent);
        }
        return contents;
    }

    private Map<String, Object> mergeContent(Map<String, Object> previous, Map<String, Object> current) {
        if (!this.incrementalOutput) {
            return QwenStreamingResponseBuilder.merge(previous, current);
        }
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(previous);
        for (String key : current.keySet()) {
            Object object = previous.get(key);
            if (object instanceof String) {
                String previousValue = (String)object;
                object = current.get(key);
                if (object instanceof String) {
                    String currentValue = (String)object;
                    merged.put(key, QwenStreamingResponseBuilder.merge(previousValue, currentValue));
                    continue;
                }
            }
            merged.put(key, current.get(key));
        }
        return merged;
    }

    private static GenerationResult newGenerationResult() {
        DashScopeResult emptyResult = new DashScopeResult();
        emptyResult.setOutput((Object)new JsonObject());
        return GenerationResult.fromDashScopeResult((DashScopeResult)emptyResult);
    }

    private static MultiModalConversationResult newMultiModalConversationResult() {
        DashScopeResult emptyResult = new DashScopeResult();
        emptyResult.setOutput((Object)new JsonObject());
        return MultiModalConversationResult.fromDashScopeResult((DashScopeResult)emptyResult);
    }

    private static <K, V> Map<K, V> merge(Map<K, V> previous, Map<K, V> current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        HashMap<K, V> merged = new HashMap<K, V>(previous);
        merged.putAll(current);
        return merged;
    }

    private static <T> List<T> merge(List<T> previous, List<T> current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        ArrayList<T> merged = new ArrayList<T>(previous.size() + current.size());
        merged.addAll(previous);
        merged.addAll(current);
        return merged;
    }

    private static String merge(String previous, String current) {
        if (previous == null) {
            return current;
        }
        if (current == null) {
            return previous;
        }
        return previous + current;
    }
}

