/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public class QwenChatResponseMetadata
extends ChatResponseMetadata {
    private final SearchInfo searchInfo;
    private final String reasoningContent;

    protected QwenChatResponseMetadata(Builder builder) {
        super((ChatResponseMetadata.Builder)builder);
        this.searchInfo = builder.searchInfo;
        this.reasoningContent = builder.reasoningContent;
    }

    public SearchInfo searchInfo() {
        return this.searchInfo;
    }

    public String reasoningContent() {
        return this.reasoningContent;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        if (this.id() != null) {
            map.put("id", this.id());
        }
        if (this.modelName() != null) {
            map.put("modelName", this.modelName());
        }
        if (this.tokenUsage() != null) {
            map.put("tokenUsage", this.tokenUsage());
        }
        if (this.finishReason() != null) {
            map.put("finishReason", this.finishReason());
        }
        if (this.searchInfo != null) {
            map.put("searchInfo", this.searchInfo);
        }
        if (this.reasoningContent != null) {
            map.put("reasoningContent", this.reasoningContent);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QwenChatResponseMetadata)) {
            return false;
        }
        QwenChatResponseMetadata that = (QwenChatResponseMetadata)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.searchInfo, that.searchInfo) && Objects.equals(this.reasoningContent, that.reasoningContent);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.searchInfo, this.reasoningContent);
    }

    public String toString() {
        return "QwenChatResponseMetadata{id=" + Utils.quoted((Object)this.id()) + ", modelName=" + Utils.quoted((Object)this.modelName()) + ", tokenUsage=" + String.valueOf(this.tokenUsage()) + ", finishReason=" + String.valueOf(this.finishReason()) + ", searchInfo=" + String.valueOf(this.searchInfo) + ", reasoningContent=" + this.reasoningContent + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ChatResponseMetadata.Builder<Builder> {
        private SearchInfo searchInfo;
        private String reasoningContent;

        public Builder searchInfo(SearchInfo searchInfo) {
            this.searchInfo = searchInfo;
            return this;
        }

        public Builder reasoningContent(String reasoningContent) {
            this.reasoningContent = reasoningContent;
            return this;
        }

        public QwenChatResponseMetadata build() {
            return new QwenChatResponseMetadata(this);
        }
    }

    public record SearchInfo(List<SearchResult> searchResults) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private List<SearchResult> searchResults;

            public Builder searchResults(List<SearchResult> searchResults) {
                this.searchResults = searchResults;
                return this;
            }

            public SearchInfo build() {
                return new SearchInfo(this.searchResults);
            }
        }
    }

    public record SearchResult(String siteName, String icon, Integer index, String title, String url) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String siteName;
            private String icon;
            private Integer index;
            private String title;
            private String url;

            public Builder siteName(String siteName) {
                this.siteName = siteName;
                return this;
            }

            public Builder icon(String icon) {
                this.icon = icon;
                return this;
            }

            public Builder index(Integer index) {
                this.index = index;
                return this;
            }

            public Builder title(String title) {
                this.title = title;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public SearchResult build() {
                return new SearchResult(this.siteName, this.icon, this.index, this.title, this.url);
            }
        }
    }
}

