/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Experimental
public class QwenChatRequestParameters
extends DefaultChatRequestParameters {
    private final Integer seed;
    private final Boolean enableSearch;
    private final SearchOptions searchOptions;
    private final TranslationOptions translationOptions;
    private final Boolean vlHighResolutionImages;
    private final Boolean isMultimodalModel;
    private final Boolean supportIncrementalOutput;
    private final Boolean enableThinking;
    private final Integer thinkingBudget;
    private final Boolean enableSanitizeMessages;
    private final Map<String, Object> custom;

    protected QwenChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.seed = builder.seed;
        this.enableSearch = builder.enableSearch;
        this.searchOptions = builder.searchOptions;
        this.translationOptions = builder.translationOptions;
        this.vlHighResolutionImages = builder.vlHighResolutionImages;
        this.isMultimodalModel = builder.isMultimodalModel;
        this.supportIncrementalOutput = builder.supportIncrementalOutput;
        this.enableThinking = (Boolean)Utils.getOrDefault((Object)builder.enableThinking, (Object)Boolean.FALSE);
        this.thinkingBudget = builder.thinkingBudget;
        this.enableSanitizeMessages = (Boolean)Utils.getOrDefault((Object)builder.enableSanitizeMessages, (Object)Boolean.TRUE);
        this.custom = builder.custom;
    }

    public Integer seed() {
        return this.seed;
    }

    public Boolean enableSearch() {
        return this.enableSearch;
    }

    public SearchOptions searchOptions() {
        return this.searchOptions;
    }

    public TranslationOptions translationOptions() {
        return this.translationOptions;
    }

    public Boolean vlHighResolutionImages() {
        return this.vlHighResolutionImages;
    }

    public Boolean isMultimodalModel() {
        return this.isMultimodalModel;
    }

    public Boolean supportIncrementalOutput() {
        return this.supportIncrementalOutput;
    }

    public Boolean enableThinking() {
        return this.enableThinking;
    }

    public Integer thinkingBudget() {
        return this.thinkingBudget;
    }

    public Boolean enableSanitizeMessages() {
        return this.enableSanitizeMessages;
    }

    public Map<String, Object> custom() {
        return this.custom;
    }

    public QwenChatRequestParameters overrideWith(ChatRequestParameters that) {
        return QwenChatRequestParameters.builder().overrideWith((ChatRequestParameters)this).overrideWith(that).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QwenChatRequestParameters)) {
            return false;
        }
        QwenChatRequestParameters that = (QwenChatRequestParameters)((Object)o);
        if (!super.equals(o)) {
            return false;
        }
        return Objects.equals(this.seed, that.seed) && Objects.equals(this.enableSearch, that.enableSearch) && Objects.equals(this.searchOptions, that.searchOptions) && Objects.equals(this.translationOptions, that.translationOptions) && Objects.equals(this.vlHighResolutionImages, that.vlHighResolutionImages) && Objects.equals(this.custom, that.custom);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.seed, this.enableSearch, this.searchOptions, this.translationOptions, this.vlHighResolutionImages, this.custom);
    }

    public String toString() {
        return "QwenChatRequestParameters{modelName=" + Utils.quoted((Object)this.modelName()) + ", temperature=" + this.temperature() + ", topP=" + this.topP() + ", topK=" + this.topK() + ", frequencyPenalty=" + this.frequencyPenalty() + ", presencePenalty=" + this.presencePenalty() + ", maxOutputTokens=" + this.maxOutputTokens() + ", stopSequences=" + String.valueOf(this.stopSequences()) + ", toolSpecifications=" + String.valueOf(this.toolSpecifications()) + ", toolChoice=" + String.valueOf(this.toolChoice()) + ", responseFormat=" + String.valueOf(this.responseFormat()) + ", seed=" + this.seed + ", enableSearch=" + this.enableSearch + ", searchOptions=" + String.valueOf(this.searchOptions) + ", translationOptions=" + String.valueOf(this.translationOptions) + ", vlHighResolutionImages=" + this.vlHighResolutionImages + ", custom=" + String.valueOf(this.custom) + "}";
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Integer seed;
        private Boolean enableSearch;
        private SearchOptions searchOptions;
        private TranslationOptions translationOptions;
        private Boolean vlHighResolutionImages;
        private Boolean isMultimodalModel;
        private Boolean supportIncrementalOutput;
        private Boolean enableThinking;
        private Integer thinkingBudget;
        private Boolean enableSanitizeMessages;
        private Map<String, Object> custom;

        public Builder overrideWith(ChatRequestParameters parameters) {
            super.overrideWith(parameters);
            if (parameters instanceof QwenChatRequestParameters) {
                QwenChatRequestParameters qwenParameters = (QwenChatRequestParameters)parameters;
                this.seed((Integer)Utils.getOrDefault((Object)qwenParameters.seed(), (Object)this.seed));
                this.enableSearch((Boolean)Utils.getOrDefault((Object)qwenParameters.enableSearch(), (Object)this.enableSearch));
                this.searchOptions((SearchOptions)Utils.getOrDefault((Object)qwenParameters.searchOptions(), (Object)this.searchOptions));
                this.translationOptions((TranslationOptions)Utils.getOrDefault((Object)qwenParameters.translationOptions(), (Object)this.translationOptions));
                this.vlHighResolutionImages((Boolean)Utils.getOrDefault((Object)qwenParameters.vlHighResolutionImages(), (Object)this.vlHighResolutionImages));
                this.enableThinking((Boolean)Utils.getOrDefault((Object)qwenParameters.enableThinking(), (Object)this.enableThinking));
                this.thinkingBudget((Integer)Utils.getOrDefault((Object)qwenParameters.thinkingBudget(), (Object)this.thinkingBudget));
                this.enableSanitizeMessages((Boolean)Utils.getOrDefault((Object)qwenParameters.enableSanitizeMessages(), (Object)this.enableSanitizeMessages));
                this.custom(Utils.getOrDefault(qwenParameters.custom(), this.custom));
                this.isMultimodalModel((Boolean)Utils.getOrDefault((Object)qwenParameters.isMultimodalModel(), (Object)this.isMultimodalModel));
                this.supportIncrementalOutput((Boolean)Utils.getOrDefault((Object)qwenParameters.supportIncrementalOutput(), (Object)this.supportIncrementalOutput));
            }
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public Builder searchOptions(SearchOptions searchOptions) {
            this.searchOptions = searchOptions;
            return this;
        }

        public Builder translationOptions(TranslationOptions translationOptions) {
            this.translationOptions = translationOptions;
            return this;
        }

        public Builder vlHighResolutionImages(Boolean vlHighResolutionImages) {
            this.vlHighResolutionImages = vlHighResolutionImages;
            return this;
        }

        public Builder isMultimodalModel(Boolean isMultimodalModel) {
            this.isMultimodalModel = isMultimodalModel;
            return this;
        }

        public Builder supportIncrementalOutput(Boolean supportIncrementalOutput) {
            this.supportIncrementalOutput = supportIncrementalOutput;
            return this;
        }

        public Builder enableThinking(Boolean enableThinking) {
            this.enableThinking = enableThinking;
            return this;
        }

        public Builder thinkingBudget(Integer thinkingBudget) {
            this.thinkingBudget = thinkingBudget;
            return this;
        }

        public Builder enableSanitizeMessages(Boolean enableSanitizeMessages) {
            this.enableSanitizeMessages = enableSanitizeMessages;
            return this;
        }

        public Builder custom(Map<String, Object> custom) {
            this.custom = custom;
            return this;
        }

        public QwenChatRequestParameters build() {
            return new QwenChatRequestParameters(this);
        }
    }

    public record SearchOptions(Boolean enableSource, Boolean enableCitation, String citationFormat, Boolean forcedSearch, String searchStrategy) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private Boolean enableSource;
            private Boolean enableCitation;
            private String citationFormat;
            private Boolean forcedSearch;
            private String searchStrategy;

            public Builder enableSource(Boolean enableSource) {
                this.enableSource = enableSource;
                return this;
            }

            public Builder enableCitation(Boolean enableCitation) {
                this.enableCitation = enableCitation;
                return this;
            }

            public Builder citationFormat(String citationFormat) {
                this.citationFormat = citationFormat;
                return this;
            }

            public Builder forcedSearch(Boolean forcedSearch) {
                this.forcedSearch = forcedSearch;
                return this;
            }

            public Builder searchStrategy(String searchStrategy) {
                this.searchStrategy = searchStrategy;
                return this;
            }

            public SearchOptions build() {
                return new SearchOptions(this.enableSource, this.enableCitation, this.citationFormat, this.forcedSearch, this.searchStrategy);
            }
        }
    }

    public record TranslationOptions(String sourceLang, String targetLang, List<TranslationOptionTerm> terms, List<TranslationOptionTerm> tmList, String domains) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String sourceLang;
            private String targetLang;
            private List<TranslationOptionTerm> terms;
            private List<TranslationOptionTerm> tmLists;
            private String domains;

            public Builder sourceLang(String sourceLang) {
                this.sourceLang = sourceLang;
                return this;
            }

            public Builder targetLang(String targetLang) {
                this.targetLang = targetLang;
                return this;
            }

            public Builder terms(List<TranslationOptionTerm> terms) {
                this.terms = terms;
                return this;
            }

            public Builder tmLists(List<TranslationOptionTerm> tmLists) {
                this.tmLists = tmLists;
                return this;
            }

            public Builder domains(String domains) {
                this.domains = domains;
                return this;
            }

            public TranslationOptions build() {
                return new TranslationOptions(this.sourceLang, this.targetLang, this.terms, this.tmLists, this.domains);
            }
        }
    }

    public record TranslationOptionTerm(String source, String target) {
        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private String source;
            private String target;

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder target(String target) {
                this.target = target;
                return this;
            }

            public TranslationOptionTerm build() {
                return new TranslationOptionTerm(this.source, this.target);
            }
        }
    }
}

