/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesis;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisOutput;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisParam;
import com.alibaba.dashscope.aigc.imagesynthesis.ImageSynthesisResult;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.community.model.dashscope.WanxHelper;
import dev.langchain4j.community.model.dashscope.WanxImageRefMode;
import dev.langchain4j.community.model.dashscope.WanxImageSize;
import dev.langchain4j.community.model.dashscope.WanxImageStyle;
import dev.langchain4j.community.model.dashscope.spi.WanxImageModelBuilderFactory;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.spi.ServiceHelper;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public class WanxImageModel
implements ImageModel {
    private final String apiKey;
    private final String modelName;
    private final WanxImageRefMode refMode;
    private final Float refStrength;
    private final Integer seed;
    private final WanxImageSize size;
    private final WanxImageStyle style;
    private final String negativePrompt;
    private final Boolean promptExtend;
    private final Boolean watermark;
    private final ImageSynthesis imageSynthesis;
    private Consumer<ImageSynthesisParam.ImageSynthesisParamBuilder<?, ?>> imageSynthesisParamCustomizer = p -> {};

    public WanxImageModel(String baseUrl, String apiKey, String modelName, WanxImageRefMode refMode, Float refStrength, Integer seed, WanxImageSize size, WanxImageStyle style, String negativePrompt, Boolean promptExtend, Boolean watermark) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("DashScope api key must be defined. Reference: https://www.alibabacloud.com/help/en/model-studio/get-api-key");
        }
        this.modelName = Utils.isNullOrBlank((String)modelName) ? "wanx-v1" : modelName;
        this.apiKey = apiKey;
        this.refMode = refMode;
        this.refStrength = refStrength;
        this.seed = seed;
        this.size = size;
        this.style = style;
        this.negativePrompt = negativePrompt;
        this.promptExtend = promptExtend;
        this.watermark = watermark;
        this.imageSynthesis = Utils.isNullOrBlank((String)baseUrl) ? new ImageSynthesis() : new ImageSynthesis("text2image", baseUrl);
    }

    public Response<Image> generate(String prompt) {
        return Response.from((Object)this.doGenerate(this.requestBuilder(prompt).n(Integer.valueOf(1))).get(0));
    }

    public Response<List<Image>> generate(String prompt, int n) {
        return Response.from(this.doGenerate(this.requestBuilder(prompt).n(Integer.valueOf(n))));
    }

    public Response<Image> edit(Image image, String prompt) {
        String imageUrl = WanxHelper.imageUrl(image, this.modelName, this.apiKey);
        ImageSynthesisParam.ImageSynthesisParamBuilder builder = this.requestBuilder(prompt).refImage(imageUrl).n(Integer.valueOf(1));
        if (imageUrl.startsWith("oss://")) {
            builder.header("X-DashScope-OssResourceResolve", (Object)"enable");
        }
        return Response.from((Object)this.doGenerate(builder).get(0));
    }

    private List<Image> doGenerate(ImageSynthesisParam.ImageSynthesisParamBuilder<?, ?> builder) {
        try {
            this.imageSynthesisParamCustomizer.accept(builder);
            ImageSynthesisResult result = this.imageSynthesis.call(builder.build());
            List<Image> images = WanxHelper.imagesFrom(result);
            if (images.isEmpty()) {
                ImageSynthesisOutput output = result.getOutput();
                String errorMessage = String.format("[%s] %s: %s", output.getTaskStatus(), output.getCode(), output.getMessage());
                throw new IllegalStateException(errorMessage);
            }
            return images;
        }
        catch (NoApiKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setImageSynthesisParamCustomizer(Consumer<ImageSynthesisParam.ImageSynthesisParamBuilder<?, ?>> imageSynthesisParamCustomizer) {
        this.imageSynthesisParamCustomizer = (Consumer)ValidationUtils.ensureNotNull(imageSynthesisParamCustomizer, (String)"imageSynthesisParamCustomizer");
    }

    private ImageSynthesisParam.ImageSynthesisParamBuilder<?, ?> requestBuilder(String prompt) {
        ImageSynthesisParam.ImageSynthesisParamBuilder builder = ((ImageSynthesisParam.ImageSynthesisParamBuilder)((ImageSynthesisParam.ImageSynthesisParamBuilder)ImageSynthesisParam.builder().apiKey(this.apiKey)).model(this.modelName)).prompt(prompt);
        if (this.seed != null) {
            builder.seed(this.seed);
        }
        if (this.size != null) {
            builder.size(this.size.toString());
        }
        if (this.style != null) {
            builder.style(this.style.toString());
        }
        if (this.refMode != null) {
            builder.parameter("ref_mode", (Object)this.refMode.toString());
        }
        if (this.refStrength != null) {
            builder.parameter("ref_strength", (Object)this.refStrength);
        }
        if (Utils.isNotNullOrBlank((String)this.negativePrompt)) {
            builder.negativePrompt(this.negativePrompt);
        }
        if (this.promptExtend != null) {
            builder.parameter("prompt_extend", (Object)this.promptExtend);
        }
        if (this.watermark != null) {
            builder.parameter("watermark", (Object)this.watermark);
        }
        return builder;
    }

    public static WanxImageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(WanxImageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            WanxImageModelBuilderFactory factory = (WanxImageModelBuilderFactory)iterator.next();
            return (WanxImageModelBuilder)factory.get();
        }
        return new WanxImageModelBuilder();
    }

    public static class WanxImageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private WanxImageRefMode refMode;
        private Float refStrength;
        private Integer seed;
        private WanxImageSize size;
        private WanxImageStyle style;
        private String negativePrompt;
        private Boolean promptExtend;
        private Boolean watermark;

        public WanxImageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public WanxImageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public WanxImageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public WanxImageModelBuilder refMode(WanxImageRefMode refMode) {
            this.refMode = refMode;
            return this;
        }

        public WanxImageModelBuilder refStrength(Float refStrength) {
            this.refStrength = refStrength;
            return this;
        }

        public WanxImageModelBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public WanxImageModelBuilder size(WanxImageSize size) {
            this.size = size;
            return this;
        }

        public WanxImageModelBuilder style(WanxImageStyle style) {
            this.style = style;
            return this;
        }

        public WanxImageModelBuilder negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return this;
        }

        public WanxImageModelBuilder promptExtend(Boolean promptExtend) {
            this.promptExtend = promptExtend;
            return this;
        }

        public WanxImageModelBuilder watermark(Boolean watermark) {
            this.watermark = watermark;
            return this;
        }

        public WanxImageModel build() {
            return new WanxImageModel(this.baseUrl, this.apiKey, this.modelName, this.refMode, this.refStrength, this.seed, this.size, this.style, this.negativePrompt, this.promptExtend, this.watermark);
        }
    }
}

