/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThan;
import dev.langchain4j.store.embedding.filter.comparison.IsGreaterThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsIn;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThan;
import dev.langchain4j.store.embedding.filter.comparison.IsLessThanOrEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import dev.langchain4j.store.embedding.filter.comparison.IsNotIn;
import dev.langchain4j.store.embedding.filter.logical.And;
import dev.langchain4j.store.embedding.filter.logical.Not;
import dev.langchain4j.store.embedding.filter.logical.Or;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.cypherdsl.support.schema_name.SchemaNames;

public class Neo4jFilterMapper {
    public static final String UNSUPPORTED_FILTER_TYPE_ERROR = "Unsupported filter type: ";
    final IncrementalKeyMap map = new IncrementalKeyMap();

    AbstractMap.SimpleEntry<String, Map<String, Object>> map(Filter filter) {
        String stringMapPair = this.getStringMapping(filter);
        return new AbstractMap.SimpleEntry<String, Map<String, Object>>(stringMapPair, this.map.getMap());
    }

    private String getStringMapping(Filter filter) {
        if (filter instanceof IsEqualTo) {
            IsEqualTo item = (IsEqualTo)filter;
            return this.getOperation(item.key(), "=", item.comparisonValue());
        }
        if (filter instanceof IsNotEqualTo) {
            IsNotEqualTo item = (IsNotEqualTo)filter;
            return this.getOperation(item.key(), "<>", item.comparisonValue());
        }
        if (filter instanceof IsGreaterThan) {
            IsGreaterThan item = (IsGreaterThan)filter;
            return this.getOperation(item.key(), ">", item.comparisonValue());
        }
        if (filter instanceof IsGreaterThanOrEqualTo) {
            IsGreaterThanOrEqualTo item = (IsGreaterThanOrEqualTo)filter;
            return this.getOperation(item.key(), ">=", item.comparisonValue());
        }
        if (filter instanceof IsLessThan) {
            IsLessThan item = (IsLessThan)filter;
            return this.getOperation(item.key(), "<", item.comparisonValue());
        }
        if (filter instanceof IsLessThanOrEqualTo) {
            IsLessThanOrEqualTo item = (IsLessThanOrEqualTo)filter;
            return this.getOperation(item.key(), "<=", item.comparisonValue());
        }
        if (filter instanceof IsIn) {
            IsIn item = (IsIn)filter;
            return this.mapIn(item);
        }
        if (filter instanceof IsNotIn) {
            IsNotIn item = (IsNotIn)filter;
            return this.mapNotIn(item);
        }
        if (filter instanceof And) {
            And item = (And)filter;
            return this.mapAnd(item);
        }
        if (filter instanceof Not) {
            Not item = (Not)filter;
            return this.mapNot(item);
        }
        if (filter instanceof Or) {
            Or item = (Or)filter;
            return this.mapOr(item);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_FILTER_TYPE_ERROR + filter.getClass().getName());
    }

    private String getOperation(String key, String operator, Object value) {
        String param = this.map.put(value);
        String sanitizedKey = (String)SchemaNames.sanitize((String)key).orElseThrow(() -> {
            String invalidSanitizeValue = String.format("The key %s, to assign to the operator %s and value %s, cannot be safely quoted", key, operator, value);
            return new RuntimeException(invalidSanitizeValue);
        });
        return String.format("n.%s %s $%s", sanitizedKey, operator, param);
    }

    public String mapIn(IsIn filter) {
        return this.getOperation(filter.key(), "IN", filter.comparisonValues());
    }

    public String mapNotIn(IsNotIn filter) {
        String inOperation = this.getOperation(filter.key(), "IN", filter.comparisonValues());
        return String.format("NOT (%s)", inOperation);
    }

    private String mapAnd(And filter) {
        return String.format("(%s) AND (%s)", this.getStringMapping(filter.left()), this.getStringMapping(filter.right()));
    }

    private String mapOr(Or filter) {
        return String.format("(%s) OR (%s)", this.getStringMapping(filter.left()), this.getStringMapping(filter.right()));
    }

    private String mapNot(Not filter) {
        return String.format("NOT (%s)", this.getStringMapping(filter.expression()));
    }

    public static class IncrementalKeyMap {
        private final Map<String, Object> map = new ConcurrentHashMap<String, Object>();
        private final AtomicInteger integer = new AtomicInteger();

        public String put(Object value) {
            String key = "param_" + this.integer.incrementAndGet();
            this.map.put(key, value);
            return key;
        }

        public Map<String, Object> getMap() {
            return this.map;
        }
    }
}

