/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.neo4j;

import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStore;
import dev.langchain4j.community.store.embedding.neo4j.Neo4jEmbeddingStoreIngestor;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.store.embedding.EmbeddingStore;

public class SummaryGraphIngestor
extends Neo4jEmbeddingStoreIngestor {
    public SummaryGraphIngestor(Builder builder) {
        super(builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Neo4jEmbeddingStoreIngestor.Builder {
        private static final String DEFAULT_RETRIEVAL = "MATCH (node)<-[:HAS_SUMMARY]-(parent)\nWITH parent, max(score) AS score, node // deduplicate parents\nRETURN parent.text AS text, score, properties(node) AS metadata\nORDER BY score DESC\nLIMIT $maxResults";
        private static final String DEFAULT_SYSTEM_PROMPT = "You are generating concise and accurate summaries based on the information found in the text.\n";
        private static final String DEFAULT_USER_PROMPT = "Generate a summary of the following input:\n{{input}}\n\nSummary:\n";
        private static final String DEFAULT_PARENT_QUERY = "UNWIND $rows AS row\nMATCH (p:SummaryChunk {parentId: $parentId})\nCREATE (p)-[:HAS_SUMMARY]->(u:%1$s {%2$s: row.%2$s})\nSET u += row.%3$s\nWITH row, u\nCALL db.create.setNodeVectorProperty(u, $embeddingProperty, row.%4$s)\nRETURN count(*)";
        private static final String DEFAULT_CHUNK_CREATION_QUERY = "CREATE (:SummaryChunk $metadata)";

        private Neo4jEmbeddingStore defaultEmbeddingStore() {
            return Neo4jEmbeddingStore.builder().driver(this.driver).retrievalQuery(DEFAULT_RETRIEVAL).entityCreationQuery(DEFAULT_PARENT_QUERY).label("Summary").indexName("summary_embedding_index").dimension(384).build();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SummaryGraphIngestor build() {
            this.systemPrompt = (String)Utils.getOrDefault((Object)this.systemPrompt, (Object)DEFAULT_SYSTEM_PROMPT);
            this.userPrompt = (String)Utils.getOrDefault((Object)this.userPrompt, (Object)DEFAULT_USER_PROMPT);
            this.query = (String)Utils.getOrDefault((Object)this.query, (Object)DEFAULT_CHUNK_CREATION_QUERY);
            this.embeddingStore = (EmbeddingStore)Utils.getOrDefault((Object)this.embeddingStore, (Object)this.defaultEmbeddingStore());
            return new SummaryGraphIngestor(this);
        }
    }
}

