/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.memory.chat.neo4j;

import dev.langchain4j.community.store.memory.chat.neo4j.Neo4jUtils;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.exceptions.Neo4jException;

public class Neo4jChatMemoryStore
implements ChatMemoryStore {
    public static final String DEFAULT_MEMORY_LABEL = "Memory";
    public static final String DEFAULT_MESSAGE_LABEL = "Message";
    public static final String DEFAULT_LAST_REL_TYPE = "LAST_MESSAGE";
    public static final String DEFAULT_REL_TYPE_NEXT = "NEXT";
    public static final String DEFAULT_ID_PROP = "id";
    public static final String DEFAULT_MESSAGE_PROP = "message";
    public static final String DEFAULT_DATABASE_NAME = "neo4j";
    public static final int DEFAULT_SIZE_VALUE = 10;
    private final Driver driver;
    private final SessionConfig config;
    private final String memoryLabel;
    private final String messageLabel;
    private final String lastMessageRelType;
    private final String nextMessageRelType;
    private final String idProperty;
    private final String messageProperty;
    private final int size;

    public Neo4jChatMemoryStore(Driver driver, SessionConfig config, String memoryLabel, String messageLabel, String lastMessageRelType, String nextMessageRelType, String idProperty, String messageProperty, String databaseName, Integer size) {
        this.driver = (Driver)ValidationUtils.ensureNotNull((Object)driver, (String)"driver");
        String dbName = (String)Utils.getOrDefault((Object)databaseName, (Object)DEFAULT_DATABASE_NAME);
        this.config = (SessionConfig)Utils.getOrDefault((Object)config, (Object)SessionConfig.forDatabase((String)dbName));
        this.memoryLabel = (String)Utils.getOrDefault((Object)memoryLabel, (Object)DEFAULT_MEMORY_LABEL);
        this.messageLabel = (String)Utils.getOrDefault((Object)messageLabel, (Object)DEFAULT_MESSAGE_LABEL);
        this.lastMessageRelType = (String)Utils.getOrDefault((Object)lastMessageRelType, (Object)DEFAULT_LAST_REL_TYPE);
        this.nextMessageRelType = (String)Utils.getOrDefault((Object)nextMessageRelType, (Object)DEFAULT_REL_TYPE_NEXT);
        this.idProperty = (String)Utils.getOrDefault((Object)idProperty, (Object)DEFAULT_ID_PROP);
        this.messageProperty = (String)Utils.getOrDefault((Object)messageProperty, (Object)DEFAULT_MESSAGE_PROP);
        this.size = (Integer)Utils.getOrDefault((Object)size, (Object)10);
    }

    public static Builder builder() {
        return new Builder();
    }

    private void createSessionNode(Object memoryId) {
        try (Session session = this.session();){
            Map<String, Object> params = Map.of("label", this.memoryLabel, "window", this.size, "memoryId", memoryId);
            String query = Cypher.merge((PatternElement[])new PatternElement[]{(PatternElement)Cypher.node((String)this.memoryLabel, (String[])new String[0]).withProperties(new Object[]{this.idProperty, Cypher.parameter((String)"memoryId")})}).build().getCypher();
            session.run(query, params);
        }
        catch (Neo4jException e) {
            Neo4jChatMemoryStore.getDescriptiveProcedureNotFoundError(e);
            throw new RuntimeException(e);
        }
    }

    public List<ChatMessage> getMessages(Object memoryIdObj) {
        List<ChatMessage> list;
        block8: {
            String memoryId = Neo4jChatMemoryStore.toMemoryIdString(memoryIdObj);
            Session session = this.session();
            try {
                String windowPar = this.size < 1 ? "" : Long.toString(this.size);
                Map<String, String> params = Map.of("label", this.memoryLabel, "window", windowPar, "memoryId", memoryId);
                Statement statement = this.buildHistoryQuery();
                String cypher = Renderer.getDefaultRenderer().render(statement);
                list = session.run(cypher, params).stream().map(i -> i.get("msg").asString(null)).filter(Objects::nonNull).map(ChatMessageDeserializer::messageFromJson).toList();
                if (session == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Neo4jException e) {
                    Neo4jChatMemoryStore.getDescriptiveProcedureNotFoundError(e);
                    throw new RuntimeException(e);
                }
            }
            session.close();
        }
        return list;
    }

    public Statement buildHistoryQuery() {
        Node firstNode = Cypher.node((String)this.memoryLabel, (String[])new String[0]).named("s");
        Node lastNode = Cypher.anyNode().named("lastNode");
        Relationship relationship = (Relationship)lastNode.relationshipFrom(Cypher.anyNode(), new String[]{this.nextMessageRelType});
        RelationshipPattern pathRel = this.size < 1 ? relationship.min(Integer.valueOf(0)) : relationship.length(Integer.valueOf(0), Integer.valueOf(this.size));
        NamedPath p = Cypher.path((String)"p").definedBy((PatternElement)pathRel);
        AliasedExpression pathLength = FunctionInvocation.create((FunctionInvocation.FunctionDefinition)Neo4jUtils.functionDef("length"), (Expression[])new Expression[]{Cypher.name((String)"p")}).as("length");
        FunctionInvocation reverseNodes = FunctionInvocation.create((FunctionInvocation.FunctionDefinition)Neo4jUtils.functionDef("reverse"), (Expression[])new Expression[]{FunctionInvocation.create((FunctionInvocation.FunctionDefinition)Neo4jUtils.functionDef("nodes"), (Expression[])new Expression[]{Cypher.name((String)"p")})});
        return ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{firstNode.relationshipTo(lastNode, new String[]{this.lastMessageRelType})}).where(firstNode.property(this.idProperty).isEqualTo((Expression)Cypher.parameter((String)"memoryId")))).match(new PatternElement[]{p}).with(new IdentifiableElement[]{p, pathLength}).orderBy((Expression)Cypher.name((String)"length")).descending().limit((Number)1).unwind((Expression)reverseNodes).as("node").returning(new Expression[]{Cypher.name((String)"node").property(this.messageProperty).as("msg")}).build();
    }

    public void updateMessages(Object memoryIdObj, List<ChatMessage> messages) {
        String memoryId = Neo4jChatMemoryStore.toMemoryIdString(memoryIdObj);
        ValidationUtils.ensureNotEmpty(messages, (String)"messages");
        List<Map> messagesValues = messages.stream().map(ChatMessageSerializer::messageToJson).map(i -> Map.of(this.messageProperty, i)).toList();
        this.createSessionNode(memoryId);
        try (Session session = this.session();){
            Node s = Cypher.node((String)this.memoryLabel, (String[])new String[0]).named("s");
            Node lastNode = Cypher.anyNode().named("lastNode");
            Relationship lastRel = ((Relationship)s.relationshipTo(lastNode, new String[]{this.lastMessageRelType})).named("lastRel");
            Node newNode = Cypher.anyNode().named("new");
            String query = ((StatementBuilder.OngoingInQueryCallWithArguments)((StatementBuilder.OngoingInQueryCallWithoutArguments)((StatementBuilder.OngoingInQueryCallWithReturnFields)((StatementBuilder.OngoingInQueryCallWithArguments)((StatementBuilder.OngoingInQueryCallWithoutArguments)((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{s}).where(s.property(this.idProperty).isEqualTo((Expression)Cypher.parameter((String)"memoryId")))).optionalMatch(new PatternElement[]{lastRel}).call(new String[]{"apoc.create.nodes"})).withArgs(new Expression[]{Cypher.raw((String)"[$label], $messages", (Object[])new Object[0])})).yield(new String[]{"node"})).with(new IdentifiableElement[]{Cypher.raw((String)"collect(node)", (Object[])new Object[0]).as("nodes"), s, lastNode, lastRel}).call(new String[]{"apoc.nodes.link"})).withArgs(new Expression[]{Cypher.raw((String)"nodes, $relType, {avoidDuplicates: true}", (Object[])new Object[0])})).withoutResults().with(new IdentifiableElement[]{Cypher.raw((String)"nodes[-1]", (Object[])new Object[0]).as("new"), s, lastNode, lastRel}).create(new PatternElement[]{s.relationshipTo(newNode, new String[]{this.lastMessageRelType})}).with(new IdentifiableElement[]{newNode, lastRel, lastNode}).where(lastNode.isNotNull()).create(new PatternElement[]{lastNode.relationshipTo(newNode, new String[]{this.nextMessageRelType})}).delete(new Named[]{lastRel}).build().getCypher();
            Map<String, List<Map>> params = Map.of("memoryId", memoryId, "relType", this.nextMessageRelType, "label", this.messageLabel, "messages", messagesValues);
            session.run(query, params);
        }
    }

    public void deleteMessages(Object memoryIdObj) {
        String memoryId = Neo4jChatMemoryStore.toMemoryIdString(memoryIdObj);
        try (Session session = this.session();){
            Node firstNode = Cypher.node((String)this.memoryLabel, (String[])new String[0]).named("s");
            Node lastNode = Cypher.anyNode().named("lastNode");
            RelationshipChain rel = ((RelationshipChain)((Relationship)firstNode.relationshipTo(lastNode, new String[]{this.lastMessageRelType})).named("lastRel").relationshipFrom(Cypher.anyNode(), new String[]{this.nextMessageRelType})).min(Integer.valueOf(0));
            NamedPath p = Cypher.path((String)"p").definedBy((PatternElement)rel);
            String query = ((StatementBuilder.OngoingReadingWithWhere)Cypher.match((PatternElement[])new PatternElement[]{firstNode}).where(firstNode.property(this.idProperty).isEqualTo((Expression)Cypher.parameter((String)"memoryId")))).optionalMatch(new PatternElement[]{p}).with(new IdentifiableElement[]{firstNode, p, Cypher.raw((String)"length(p)", (Object[])new Object[0]).as("length")}).orderBy(Cypher.raw((String)"length", (Object[])new Object[0])).descending().limit((Number)1).detachDelete(new Named[]{firstNode, p}).build().getCypher();
            Map<String, String> params = Map.of("memoryId", memoryId, "relType", this.lastMessageRelType, "label", this.memoryLabel);
            session.run(query, params);
        }
        catch (Neo4jException e) {
            Neo4jChatMemoryStore.getDescriptiveProcedureNotFoundError(e);
            throw new RuntimeException(e);
        }
    }

    private static void getDescriptiveProcedureNotFoundError(Neo4jException e) {
        if ("Neo.ClientError.Procedure.ProcedureNotFound".equals(e.code())) {
            throw new Neo4jException("Please ensure the APOC plugin is installed in Neo4j", (Throwable)e);
        }
    }

    private static String toMemoryIdString(Object memoryId) {
        boolean isNullOrEmpty;
        boolean bl = isNullOrEmpty = memoryId == null || memoryId.toString().trim().isEmpty();
        if (isNullOrEmpty) {
            throw new IllegalArgumentException("memoryId cannot be null or empty");
        }
        return memoryId.toString();
    }

    private Session session() {
        return this.driver.session(this.config);
    }

    public static class Builder {
        private Driver driver;
        private SessionConfig config;
        private String memoryLabel;
        private String messageLabel;
        private String lastMessageRelType;
        private String nextMessageRelType;
        private String idProperty;
        private String messageProperty;
        private String databaseName;
        private Integer size;

        public Builder driver(Driver driver) {
            this.driver = driver;
            return this;
        }

        public Builder config(SessionConfig config) {
            this.config = config;
            return this;
        }

        public Builder memoryLabel(String memoryLabel) {
            this.memoryLabel = memoryLabel;
            return this;
        }

        public Builder messageLabel(String messageLabel) {
            this.messageLabel = messageLabel;
            return this;
        }

        public Builder idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this;
        }

        public Builder messageProperty(String messageProperty) {
            this.messageProperty = messageProperty;
            return this;
        }

        public Builder lastMessageRelType(String lastMessageRelType) {
            this.lastMessageRelType = lastMessageRelType;
            return this;
        }

        public Builder nextMessageRelType(String nextMessageRelType) {
            this.nextMessageRelType = nextMessageRelType;
            return this;
        }

        public Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public Builder withBasicAuth(String uri, String user, String password) {
            this.driver = GraphDatabase.driver((String)uri, (AuthToken)AuthTokens.basic((String)user, (String)password));
            return this;
        }

        public Neo4jChatMemoryStore build() {
            return new Neo4jChatMemoryStore(this.driver, this.config, this.memoryLabel, this.messageLabel, this.lastMessageRelType, this.nextMessageRelType, this.idProperty, this.messageProperty, this.databaseName, this.size);
        }
    }
}

