/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.community.model.qianfan.QianfanChatModelNameEnum;
import dev.langchain4j.community.model.qianfan.client.QianfanClient;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.qianfan.spi.QianfanChatModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.ChatLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;
import java.util.List;

public class QianfanChatModel
implements ChatLanguageModel {
    private final QianfanClient client;
    private final String baseUrl;
    private final Double temperature;
    private final Double topP;
    private final String modelName;
    private final String endpoint;
    private final Double penaltyScore;
    private final Integer maxRetries;
    private final String responseFormat;
    private final String userId;
    private final List<String> stop;
    private final Integer maxOutputTokens;
    private final String system;

    public QianfanChatModel(String baseUrl, String apiKey, String secretKey, Double temperature, Integer maxRetries, Double topP, String modelName, String endpoint, String responseFormat, Double penaltyScore, Boolean logRequests, Boolean logResponses, String userId, List<String> stop, Integer maxOutputTokens, String system, Proxy proxy) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        this.modelName = modelName;
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanChatModelNameEnum.fromModelName(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan is no such model name. You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com");
        this.client = QianfanClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logResponses(logResponses).proxy(proxy).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.topP = topP;
        this.penaltyScore = penaltyScore;
        this.responseFormat = responseFormat;
        this.maxOutputTokens = maxOutputTokens;
        this.stop = stop;
        this.userId = userId;
        this.system = system;
    }

    public Response<AiMessage> generate(List<ChatMessage> messages) {
        return this.generate(messages, null, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return this.generate(messages, toolSpecifications, null);
    }

    public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new RuntimeException("Not supported");
    }

    private Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, ToolSpecification toolThatMustBeExecuted) {
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder().messages(InternalQianfanHelper.toOpenAiMessages(messages)).temperature(this.temperature).topP(this.topP).maxOutputTokens(this.maxOutputTokens).stop(this.stop).system(this.system).userId(this.userId).penaltyScore(this.penaltyScore).responseFormat(this.responseFormat);
        if (this.system == null || this.system.isEmpty()) {
            builder.system(InternalQianfanHelper.getSystemMessage(messages));
        }
        if (toolSpecifications != null && !toolSpecifications.isEmpty()) {
            builder.functions(InternalQianfanHelper.toFunctions(toolSpecifications));
        }
        ChatCompletionRequest param = builder.build();
        ChatCompletionResponse response = (ChatCompletionResponse)RetryUtils.withRetry(() -> (ChatCompletionResponse)this.client.chatCompletion(param, this.endpoint).execute(), (int)this.maxRetries);
        return Response.from((Object)InternalQianfanHelper.aiMessageFrom(response), (TokenUsage)InternalQianfanHelper.tokenUsageFrom(response), (FinishReason)InternalQianfanHelper.finishReasonFrom(response.getFinishReason()));
    }

    public static QianfanChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanChatModelBuilderFactory factory = (QianfanChatModelBuilderFactory)iterator.next();
            return (QianfanChatModelBuilder)factory.get();
        }
        return new QianfanChatModelBuilder();
    }

    public static class QianfanChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Double temperature;
        private Integer maxRetries;
        private Double topP;
        private String modelName;
        private String endpoint;
        private String responseFormat;
        private Double penaltyScore;
        private Boolean logRequests;
        private Boolean logResponses;
        private String userId;
        private List<String> stop;
        private Integer maxOutputTokens;
        private String system;
        private Proxy proxy;

        public QianfanChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanChatModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public QianfanChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public QianfanChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QianfanChatModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanChatModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanChatModelBuilder responseFormat(String responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public QianfanChatModelBuilder penaltyScore(Double penaltyScore) {
            this.penaltyScore = penaltyScore;
            return this;
        }

        public QianfanChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanChatModelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public QianfanChatModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public QianfanChatModelBuilder maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this;
        }

        public QianfanChatModelBuilder system(String system) {
            this.system = system;
            return this;
        }

        public QianfanChatModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanChatModel build() {
            return new QianfanChatModel(this.baseUrl, this.apiKey, this.secretKey, this.temperature, this.maxRetries, this.topP, this.modelName, this.endpoint, this.responseFormat, this.penaltyScore, this.logRequests, this.logResponses, this.userId, this.stop, this.maxOutputTokens, this.system, this.proxy);
        }
    }
}

