/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.community.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.community.model.qianfan.QianfanLanguageModelNameEnum;
import dev.langchain4j.community.model.qianfan.client.QianfanClient;
import dev.langchain4j.community.model.qianfan.client.completion.CompletionRequest;
import dev.langchain4j.community.model.qianfan.client.completion.CompletionResponse;
import dev.langchain4j.community.model.qianfan.spi.QianfanLanguageModelBuilderFactory;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.util.Iterator;

public class QianfanLanguageModel
implements LanguageModel {
    private final QianfanClient client;
    private final String baseUrl;
    private final Double temperature;
    private final Double topP;
    private final String modelName;
    private final Double penaltyScore;
    private final Integer maxRetries;
    private final Integer topK;
    private final String endpoint;

    public QianfanLanguageModel(String baseUrl, String apiKey, String secretKey, Double temperature, Integer maxRetries, Integer topK, Double topP, String modelName, String endpoint, Double penaltyScore, Boolean logRequests, Boolean logResponses, Proxy proxy) {
        if (Utils.isNullOrBlank((String)apiKey) || Utils.isNullOrBlank((String)secretKey)) {
            throw new IllegalArgumentException(" api key and secret key must be defined. It can be generated here: https://console.bce.baidu.com/qianfan/ais/console/applicationConsole/application");
        }
        this.modelName = modelName;
        String string = this.endpoint = Utils.isNullOrBlank((String)endpoint) ? QianfanLanguageModelNameEnum.fromModelName(modelName) : endpoint;
        if (Utils.isNullOrBlank((String)this.endpoint)) {
            throw new IllegalArgumentException("Qianfan is no such model name. You can see model name here: https://cloud.baidu.com/doc/WENXINWORKSHOP/s/Nlks5zkzu");
        }
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)"https://aip.baidubce.com");
        this.client = QianfanClient.builder().baseUrl(this.baseUrl).apiKey(apiKey).secretKey(secretKey).logRequests(logRequests).logResponses(logResponses).proxy(proxy).build();
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.topP = topP;
        this.topK = topK;
        this.penaltyScore = penaltyScore;
    }

    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).topK(this.topK).topP(this.topP).temperature(this.temperature).penaltyScore(this.penaltyScore).build();
        CompletionResponse response = (CompletionResponse)RetryUtils.withRetry(() -> (CompletionResponse)this.client.completion(request, false, this.endpoint).execute(), (int)this.maxRetries);
        return Response.from((Object)response.getResult(), (TokenUsage)InternalQianfanHelper.tokenUsageFrom(response), (FinishReason)InternalQianfanHelper.finishReasonFrom(response.getFinishReason()));
    }

    public static QianfanLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(QianfanLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            QianfanLanguageModelBuilderFactory factory = (QianfanLanguageModelBuilderFactory)iterator.next();
            return (QianfanLanguageModelBuilder)factory.get();
        }
        return new QianfanLanguageModelBuilder();
    }

    public static class QianfanLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String secretKey;
        private Double temperature;
        private Integer maxRetries;
        private Integer topK;
        private Double topP;
        private String modelName;
        private String endpoint;
        private Double penaltyScore;
        private Boolean logRequests;
        private Boolean logResponses;
        private Proxy proxy;

        public QianfanLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public QianfanLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public QianfanLanguageModelBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public QianfanLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public QianfanLanguageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public QianfanLanguageModelBuilder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public QianfanLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public QianfanLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public QianfanLanguageModelBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public QianfanLanguageModelBuilder penaltyScore(Double penaltyScore) {
            this.penaltyScore = penaltyScore;
            return this;
        }

        public QianfanLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public QianfanLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public QianfanLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public QianfanLanguageModel build() {
            return new QianfanLanguageModel(this.baseUrl, this.apiKey, this.secretKey, this.temperature, this.maxRetries, this.topK, this.topP, this.modelName, this.endpoint, this.penaltyScore, this.logRequests, this.logResponses, this.proxy);
        }
    }
}

