/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.qianfan;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.community.model.qianfan.InternalQianfanHelper;
import dev.langchain4j.community.model.qianfan.client.Usage;
import dev.langchain4j.community.model.qianfan.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.qianfan.client.chat.FunctionCall;
import dev.langchain4j.community.model.qianfan.client.completion.CompletionResponse;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.TokenCountEstimator;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class QianfanStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final StringBuffer toolNameBuilder = new StringBuffer();
    private final StringBuffer toolArgumentsBuilder = new StringBuffer();
    private final Map<Integer, ToolExecutionRequestBuilder> indexToToolExecutionRequestBuilder = new ConcurrentHashMap<Integer, ToolExecutionRequestBuilder>();
    private volatile String finishReason;
    private Integer inputTokenCount;
    private Integer outputTokenCount;

    public QianfanStreamingResponseBuilder(Integer inputTokenCount) {
        this.inputTokenCount = inputTokenCount;
    }

    public void append(ChatCompletionResponse partialResponse) {
        FunctionCall functionCall;
        Usage usage;
        String content;
        if (partialResponse == null) {
            return;
        }
        String finishReason = partialResponse.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((content = partialResponse.getResult()) != null) {
            this.contentBuilder.append(content);
        }
        if ((usage = partialResponse.getUsage()) != null) {
            this.inputTokenCount = usage.getPromptTokens();
            this.outputTokenCount = usage.getCompletionTokens();
        }
        if ((functionCall = partialResponse.getFunctionCall()) != null) {
            if (functionCall.getName() != null) {
                this.toolNameBuilder.append(functionCall.getName());
            }
            if (functionCall.getArguments() != null) {
                this.toolArgumentsBuilder.append(functionCall.getArguments());
            }
        }
    }

    public void append(CompletionResponse partialResponse) {
        String token;
        if (partialResponse == null) {
            return;
        }
        String result = partialResponse.getResult();
        if (Utils.isNullOrBlank((String)result)) {
            return;
        }
        String finishReason = partialResponse.getFinishReason();
        if (finishReason != null) {
            this.finishReason = finishReason;
        }
        if ((token = partialResponse.getResult()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public ChatResponse build(TokenCountEstimator TokenCountEstimator2, boolean forcefulToolExecution) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return ChatResponse.builder().aiMessage(AiMessage.from((String)content)).tokenUsage(this.tokenUsage(content, TokenCountEstimator2)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return ChatResponse.builder().aiMessage(AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest})).tokenUsage(this.tokenUsage(Collections.singletonList(toolExecutionRequest), TokenCountEstimator2, forcefulToolExecution)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List<ToolExecutionRequest> toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            return ChatResponse.builder().aiMessage(AiMessage.from(toolExecutionRequests)).tokenUsage(this.tokenUsage(toolExecutionRequests, TokenCountEstimator2, forcefulToolExecution)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        return null;
    }

    public Response<String> build(TokenCountEstimator TokenCountEstimator2) {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return Response.from((Object)content, (TokenUsage)this.tokenUsage(content, TokenCountEstimator2), (FinishReason)InternalQianfanHelper.finishReasonFrom(this.finishReason));
        }
        return null;
    }

    private TokenUsage tokenUsage(String content, TokenCountEstimator TokenCountEstimator2) {
        if (TokenCountEstimator2 == null) {
            return null;
        }
        int outputTokenCount = TokenCountEstimator2.estimateTokenCountInText(content);
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(outputTokenCount));
    }

    private TokenUsage tokenUsage(List<ToolExecutionRequest> toolExecutionRequests, TokenCountEstimator TokenCountEstimator2, boolean forcefulToolExecution) {
        if (TokenCountEstimator2 == null) {
            return null;
        }
        return new TokenUsage(this.inputTokenCount, Integer.valueOf(0));
    }

    public ChatResponse build() {
        String content = this.contentBuilder.toString();
        if (!content.isEmpty()) {
            return ChatResponse.builder().aiMessage(AiMessage.from((String)content)).tokenUsage(new TokenUsage(this.inputTokenCount, this.outputTokenCount)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        String toolName = this.toolNameBuilder.toString();
        if (!toolName.isEmpty()) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(toolName).arguments(this.toolArgumentsBuilder.toString()).build();
            return ChatResponse.builder().aiMessage(AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest})).tokenUsage(new TokenUsage(this.inputTokenCount, this.outputTokenCount)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        if (!this.indexToToolExecutionRequestBuilder.isEmpty()) {
            List toolExecutionRequests = this.indexToToolExecutionRequestBuilder.values().stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).collect(Collectors.toList());
            return ChatResponse.builder().aiMessage(AiMessage.from(toolExecutionRequests)).tokenUsage(new TokenUsage(this.inputTokenCount, this.outputTokenCount)).finishReason(InternalQianfanHelper.finishReasonFrom(this.finishReason)).build();
        }
        return null;
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

