/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.redis;

import dev.langchain4j.community.store.embedding.redis.MetricType;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.json.Path2;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

public class RedisSchema {
    public static final String SCORE_FIELD_NAME = "vector_score";
    public static final String JSON_KEY = "$";
    public static final Path2 JSON_SET_PATH = Path2.of((String)"$");
    public static final String JSON_PATH_PREFIX = "$.";
    private static final VectorField.VectorAlgorithm DEFAULT_VECTOR_ALGORITHM = VectorField.VectorAlgorithm.HNSW;
    private static final MetricType DEFAULT_METRIC_TYPE = MetricType.COSINE;
    private final String indexName;
    private final String prefix;
    private final String vectorFieldName;
    private final String scalarFieldName;
    private final Map<String, SchemaField> metadataConfig;
    private final VectorField.VectorAlgorithm vectorAlgorithm;
    private final Integer dimension;
    private final MetricType metricType;

    private RedisSchema(Builder builder) {
        ValidationUtils.ensureTrue((boolean)builder.prefix.endsWith(":"), (String)"Prefix should end with a ':'");
        this.indexName = builder.indexName;
        this.prefix = builder.prefix;
        this.vectorFieldName = builder.vectorFieldName;
        this.scalarFieldName = builder.scalarFieldName;
        this.vectorAlgorithm = builder.vectorAlgorithm;
        this.dimension = builder.dimension;
        this.metricType = builder.metricType;
        this.metadataConfig = builder.metadataConfig;
    }

    SchemaField[] toSchemaFields() {
        HashMap<String, Object> vectorAttrs = new HashMap<String, Object>();
        vectorAttrs.put("DIM", this.dimension);
        vectorAttrs.put("DISTANCE_METRIC", this.metricType.name());
        vectorAttrs.put("TYPE", "FLOAT32");
        vectorAttrs.put("INITIAL_CAP", 5);
        ArrayList<Object> fields = new ArrayList<Object>();
        fields.add(TextField.of((String)(JSON_PATH_PREFIX + this.scalarFieldName)).as(this.scalarFieldName).weight(1.0));
        fields.add(VectorField.builder().fieldName(JSON_PATH_PREFIX + this.vectorFieldName).algorithm(this.vectorAlgorithm).attributes(vectorAttrs).as(this.vectorFieldName).build());
        fields.addAll(this.metadataConfig.values());
        return fields.toArray(new SchemaField[0]);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getVectorFieldName() {
        return this.vectorFieldName;
    }

    public String getScalarFieldName() {
        return this.scalarFieldName;
    }

    public Map<String, SchemaField> getMetadataConfig() {
        return this.metadataConfig;
    }

    public VectorField.VectorAlgorithm getVectorAlgorithm() {
        return this.vectorAlgorithm;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String indexName;
        private String prefix = "embedding:";
        private String vectorFieldName = "vector";
        private String scalarFieldName = "text";
        private Map<String, SchemaField> metadataConfig = new HashMap<String, SchemaField>();
        private VectorField.VectorAlgorithm vectorAlgorithm = DEFAULT_VECTOR_ALGORITHM;
        private Integer dimension;
        private final MetricType metricType = DEFAULT_METRIC_TYPE;

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder vectorFieldName(String vectorFieldName) {
            this.vectorFieldName = vectorFieldName;
            return this;
        }

        public Builder scalarFieldName(String scalarFieldName) {
            this.scalarFieldName = scalarFieldName;
            return this;
        }

        public Builder vectorAlgorithm(VectorField.VectorAlgorithm vectorAlgorithm) {
            this.vectorAlgorithm = vectorAlgorithm;
            return this;
        }

        public Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder metadataConfig(Map<String, SchemaField> metadataConfig) {
            this.metadataConfig = metadataConfig;
            return this;
        }

        public RedisSchema build() {
            return new RedisSchema(this);
        }
    }
}

