/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.memory.chat.redis;

import dev.langchain4j.community.store.memory.chat.redis.RedisChatMemoryStoreException;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisPooled;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.json.DefaultGsonObjectMapper;
import redis.clients.jedis.json.JsonObjectMapper;

public class RedisChatMemoryStore
implements ChatMemoryStore {
    private final JedisPooled client;
    private final String keyPrefix;
    private final Long ttl;
    private JsonObjectMapper jsonMapper;

    public RedisChatMemoryStore(String host, Integer port, String user, String password) {
        this(host, port, user, password, "", 0L);
    }

    public RedisChatMemoryStore(String host, Integer port, String user, String password, String prefix, Long ttl) {
        String finalHost = ValidationUtils.ensureNotBlank((String)host, (String)"host");
        int finalPort = (Integer)ValidationUtils.ensureNotNull((Object)port, (String)"port");
        if (user != null) {
            String finalUser = ValidationUtils.ensureNotBlank((String)user, (String)"user");
            String finalPassword = ValidationUtils.ensureNotBlank((String)password, (String)"password");
            this.client = new JedisPooled(finalHost, finalPort, finalUser, finalPassword);
        } else {
            this.client = new JedisPooled(finalHost, finalPort);
        }
        this.keyPrefix = (String)ValidationUtils.ensureNotNull((Object)prefix, (String)"prefix");
        this.ttl = (Long)ValidationUtils.ensureNotNull((Object)ttl, (String)"ttl");
        this.jsonMapper = new DefaultGsonObjectMapper();
    }

    public List<ChatMessage> getMessages(Object memoryId) {
        String json = this.jsonMapper.toJson(this.client.jsonGet(this.toRedisKey(memoryId)));
        return json == null ? new ArrayList() : ChatMessageDeserializer.messagesFromJson((String)json);
    }

    public void updateMessages(Object memoryId, List<ChatMessage> messages) {
        String res;
        String json = ChatMessageSerializer.messagesToJson((List)((List)ValidationUtils.ensureNotEmpty(messages, (String)"messages")));
        String key = this.toRedisKey(memoryId);
        if (this.ttl > 0L) {
            try (Pipeline pipeline = this.client.pipelined();){
                pipeline.jsonSet(key, (Object)json);
                pipeline.expire(key, this.ttl.longValue());
                List results = pipeline.syncAndReturnAll();
                res = (String)results.get(0);
            }
        } else {
            res = this.client.jsonSet(key, (Object)json);
        }
        if (!"OK".equals(res)) {
            throw new RedisChatMemoryStoreException("Set memory error, msg=" + res);
        }
    }

    public void deleteMessages(Object memoryId) {
        this.client.jsonDel(this.toRedisKey(memoryId));
    }

    private String toMemoryIdString(Object memoryId) {
        boolean isNullOrEmpty;
        boolean bl = isNullOrEmpty = memoryId == null || memoryId.toString().trim().isEmpty();
        if (isNullOrEmpty) {
            throw new IllegalArgumentException("memoryId cannot be null or empty");
        }
        return memoryId.toString();
    }

    private String toRedisKey(Object memoryId) {
        return this.keyPrefix + this.toMemoryIdString(memoryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String user;
        private String password;
        private Long ttl = 0L;
        private String prefix = "";

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public RedisChatMemoryStore build() {
            return new RedisChatMemoryStore(this.host, this.port, this.user, this.password, this.prefix, this.ttl);
        }
    }
}

