/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.community.model.xinference.client.XinferenceClient;
import dev.langchain4j.community.model.xinference.client.rerank.RerankRequest;
import dev.langchain4j.community.model.xinference.client.rerank.RerankResponse;
import dev.langchain4j.community.model.xinference.client.rerank.RerankResult;
import dev.langchain4j.community.model.xinference.client.rerank.RerankTokens;
import dev.langchain4j.community.model.xinference.spi.XinferenceScoringModelBuilderFactory;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.model.scoring.ScoringModel;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class XinferenceScoringModel
implements ScoringModel {
    private final XinferenceClient client;
    private final String modelName;
    private final Integer topN;
    private final Boolean returnDocuments;
    private final Boolean returnLen;
    private final Integer maxRetries;

    public XinferenceScoringModel(String baseUrl, String apiKey, String modelName, Integer topN, Boolean returnDocuments, Boolean returnLen, Integer maxRetries, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = XinferenceClient.builder().baseUrl(baseUrl).apiKey(apiKey).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.topN = topN;
        this.returnDocuments = (Boolean)Utils.getOrDefault((Object)returnDocuments, (Object)false);
        this.returnLen = (Boolean)Utils.getOrDefault((Object)returnLen, (Object)true);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
    }

    public Response<List<Double>> scoreAll(List<TextSegment> segments, String query) {
        List<String> documents = segments.stream().map(TextSegment::text).toList();
        RerankRequest request = RerankRequest.builder().model(this.modelName).query(query).documents(documents).topN(this.topN).returnDocuments(this.returnDocuments).returnLen(this.returnLen).build();
        RerankResponse response = (RerankResponse)RetryUtils.withRetry(() -> this.client.rerank(request).execute(), (int)this.maxRetries);
        List scores = response.getResults().stream().sorted(Comparator.comparingInt(RerankResult::getIndex)).map(RerankResult::getRelevanceScore).collect(Collectors.toList());
        RerankTokens tokens = Optional.ofNullable(response.getMeta().getTokens()).orElse(RerankTokens.builder().inputTokens(0).outputTokens(0).build());
        return Response.from(scores, (TokenUsage)new TokenUsage(tokens.getInputTokens(), tokens.getOutputTokens()));
    }

    public static XinferenceScoringModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(XinferenceScoringModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            XinferenceScoringModelBuilderFactory factory = (XinferenceScoringModelBuilderFactory)iterator.next();
            return (XinferenceScoringModelBuilder)factory.get();
        }
        return new XinferenceScoringModelBuilder();
    }

    public static class XinferenceScoringModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Integer topN;
        private Boolean returnDocuments;
        private Boolean returnLen;
        private Integer maxRetries;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public XinferenceScoringModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public XinferenceScoringModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public XinferenceScoringModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public XinferenceScoringModelBuilder topN(Integer topN) {
            this.topN = topN;
            return this;
        }

        public XinferenceScoringModelBuilder returnDocuments(Boolean returnDocuments) {
            this.returnDocuments = returnDocuments;
            return this;
        }

        public XinferenceScoringModelBuilder returnLen(Boolean returnLen) {
            this.returnLen = returnLen;
            return this;
        }

        public XinferenceScoringModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public XinferenceScoringModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public XinferenceScoringModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public XinferenceScoringModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public XinferenceScoringModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public XinferenceScoringModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public XinferenceScoringModel build() {
            return new XinferenceScoringModel(this.baseUrl, this.apiKey, this.modelName, this.topN, this.returnDocuments, this.returnLen, this.maxRetries, this.timeout, this.proxy, this.logRequests, this.logResponses, this.customHeaders);
        }
    }
}

