/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.community.model.xinference.XinferenceStreamingResponseBuilder;
import dev.langchain4j.community.model.xinference.client.XinferenceClient;
import dev.langchain4j.community.model.xinference.client.completion.CompletionChoice;
import dev.langchain4j.community.model.xinference.client.completion.CompletionRequest;
import dev.langchain4j.community.model.xinference.client.completion.CompletionResponse;
import dev.langchain4j.community.model.xinference.client.shared.StreamOptions;
import dev.langchain4j.community.model.xinference.spi.XinferenceStreamingLanguageModelBuilderFactory;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XinferenceStreamingLanguageModel
implements StreamingLanguageModel {
    private final XinferenceClient client;
    private final String modelName;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final String user;

    public XinferenceStreamingLanguageModel(String baseUrl, String apiKey, String modelName, Integer maxTokens, Double temperature, Double topP, Integer logprobs, Boolean echo, List<String> stop, Double presencePenalty, Double frequencyPenalty, String user, Duration timeout, Proxy proxy, Boolean logRequests, Boolean logResponses, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = XinferenceClient.builder().baseUrl(baseUrl).apiKey(apiKey).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logStreamingResponses(logResponses).customHeaders(customHeaders).build();
        this.modelName = ValidationUtils.ensureNotBlank((String)modelName, (String)"modelName");
        this.maxTokens = maxTokens;
        this.temperature = temperature;
        this.topP = topP;
        this.logprobs = logprobs;
        this.echo = echo;
        this.stop = stop;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.user = user;
    }

    public void generate(String prompt, StreamingResponseHandler<String> handler) {
        CompletionRequest request = CompletionRequest.builder().stream(true).streamOptions(StreamOptions.of(true)).model(this.modelName).prompt(prompt).maxTokens(this.maxTokens).temperature(this.temperature).topP(this.topP).logprobs(this.logprobs).echo(this.echo).stop(this.stop).presencePenalty(this.presencePenalty).frequencyPenalty(this.frequencyPenalty).user(this.user).build();
        XinferenceStreamingResponseBuilder responseBuilder = new XinferenceStreamingResponseBuilder();
        this.client.completions(request).onPartialResponse(partialResponse -> {
            String text;
            responseBuilder.append((CompletionResponse)partialResponse);
            List<CompletionChoice> choices = partialResponse.getChoices();
            if (!Utils.isNullOrEmpty(choices) && Utils.isNotNullOrEmpty((String)(text = choices.get(0).getText()))) {
                handler.onNext(text);
            }
        }).onComplete(() -> {
            Response<AiMessage> response = responseBuilder.build();
            handler.onComplete(Response.from((Object)((AiMessage)response.content()).text(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason()));
        }).onError(arg_0 -> handler.onError(arg_0)).execute();
    }

    public static XinferenceStreamingLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(XinferenceStreamingLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            XinferenceStreamingLanguageModelBuilderFactory factory = (XinferenceStreamingLanguageModelBuilderFactory)iterator.next();
            return (XinferenceStreamingLanguageModelBuilder)factory.get();
        }
        return new XinferenceStreamingLanguageModelBuilder();
    }

    public static class XinferenceStreamingLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String modelName;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private String user;
        private Duration timeout;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Map<String, String> customHeaders;

        public XinferenceStreamingLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder user(String user) {
            this.user = user;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public XinferenceStreamingLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public XinferenceStreamingLanguageModel build() {
            return new XinferenceStreamingLanguageModel(this.baseUrl, this.apiKey, this.modelName, this.maxTokens, this.temperature, this.topP, this.logprobs, this.echo, this.stop, this.presencePenalty, this.frequencyPenalty, this.user, this.timeout, this.proxy, this.logRequests, this.logResponses, this.customHeaders);
        }
    }
}

