/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.community.model.xinference.InternalXinferenceHelper;
import dev.langchain4j.community.model.xinference.client.chat.ChatCompletionChoice;
import dev.langchain4j.community.model.xinference.client.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.xinference.client.chat.Delta;
import dev.langchain4j.community.model.xinference.client.chat.message.FunctionCall;
import dev.langchain4j.community.model.xinference.client.completion.CompletionChoice;
import dev.langchain4j.community.model.xinference.client.completion.CompletionResponse;
import dev.langchain4j.community.model.xinference.client.shared.CompletionUsage;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class XinferenceStreamingResponseBuilder {
    private final StringBuffer contentBuilder = new StringBuffer();
    private final AtomicReference<String> responseId = new AtomicReference();
    private final AtomicReference<String> responseModel = new AtomicReference();
    private volatile TokenUsage tokenUsage;
    private volatile FinishReason finishReason;
    private volatile List<ToolExecutionRequestBuilder> toolExecutionRequestList;

    public void append(ChatCompletionResponse partialResponse) {
        Delta delta;
        List<ChatCompletionChoice> choices;
        CompletionUsage usage;
        if (partialResponse == null) {
            return;
        }
        if (Utils.isNotNullOrBlank((String)partialResponse.getId())) {
            this.responseId.set(partialResponse.getId());
        }
        if (Utils.isNotNullOrBlank((String)partialResponse.getModel())) {
            this.responseModel.set(partialResponse.getModel());
        }
        if ((usage = partialResponse.getUsage()) != null) {
            this.tokenUsage = InternalXinferenceHelper.tokenUsageFrom(usage);
        }
        if ((choices = partialResponse.getChoices()) == null || choices.isEmpty()) {
            return;
        }
        ChatCompletionChoice chatCompletionChoice = choices.get(0);
        if (chatCompletionChoice == null) {
            return;
        }
        String finishReason = chatCompletionChoice.getFinishReason();
        if (finishReason != null) {
            this.finishReason = InternalXinferenceHelper.finishReasonFrom(finishReason);
        }
        if ((delta = chatCompletionChoice.getDelta()) == null) {
            return;
        }
        String content = delta.getContent();
        if (content != null) {
            this.contentBuilder.append(content);
            return;
        }
        if (!Utils.isNullOrEmpty(delta.getToolCalls())) {
            this.toolExecutionRequestList = delta.getToolCalls().stream().map(toolCall -> {
                FunctionCall functionCall;
                ToolExecutionRequestBuilder toolExecutionRequestBuilder = new ToolExecutionRequestBuilder();
                if (toolCall.getId() != null) {
                    toolExecutionRequestBuilder.idBuilder.append(toolCall.getId());
                }
                if ((functionCall = toolCall.getFunction()).getName() != null) {
                    toolExecutionRequestBuilder.nameBuilder.append(functionCall.getName());
                }
                if (functionCall.getArguments() != null) {
                    toolExecutionRequestBuilder.argumentsBuilder.append(functionCall.getArguments());
                }
                return toolExecutionRequestBuilder;
            }).toList();
        }
    }

    public void append(CompletionResponse partialResponse) {
        String token;
        List<CompletionChoice> choices;
        if (partialResponse == null) {
            return;
        }
        CompletionUsage usage = partialResponse.getUsage();
        if (usage != null) {
            this.tokenUsage = InternalXinferenceHelper.tokenUsageFrom(usage);
        }
        if ((choices = partialResponse.getChoices()) == null || choices.isEmpty()) {
            return;
        }
        CompletionChoice completionChoice = choices.get(0);
        if (completionChoice == null) {
            return;
        }
        String finishReason = completionChoice.getFinishReason();
        if (finishReason != null) {
            this.finishReason = InternalXinferenceHelper.finishReasonFrom(finishReason);
        }
        if ((token = completionChoice.getText()) != null) {
            this.contentBuilder.append(token);
        }
    }

    public Response<AiMessage> build() {
        String text = this.contentBuilder.toString();
        if (!Utils.isNullOrEmpty(this.toolExecutionRequestList)) {
            List<ToolExecutionRequest> list = this.toolExecutionRequestList.stream().map(it -> ToolExecutionRequest.builder().id(it.idBuilder.toString()).name(it.nameBuilder.toString()).arguments(it.argumentsBuilder.toString()).build()).toList();
            AiMessage aiMessage = Utils.isNullOrBlank((String)text) ? AiMessage.from(list) : AiMessage.from((String)text, list);
            return Response.from((Object)aiMessage, (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        if (!Utils.isNullOrBlank((String)text)) {
            return Response.from((Object)AiMessage.from((String)text), (TokenUsage)this.tokenUsage, (FinishReason)this.finishReason);
        }
        return null;
    }

    public String getResponseId() {
        return this.responseId.get();
    }

    public String getResponseModel() {
        return this.responseModel.get();
    }

    private static class ToolExecutionRequestBuilder {
        private final StringBuffer idBuilder = new StringBuffer();
        private final StringBuffer nameBuilder = new StringBuffer();
        private final StringBuffer argumentsBuilder = new StringBuffer();

        private ToolExecutionRequestBuilder() {
        }
    }
}

