/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.chat.Tool;
import dev.langchain4j.community.model.xinference.client.chat.message.Message;
import dev.langchain4j.community.model.xinference.client.shared.StreamOptions;
import java.util.List;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class ChatCompletionRequest {
    private final String model;
    private final List<Message> messages;
    private final Double temperature;
    private final Double topP;
    private final Integer n;
    private final Boolean stream;
    private final StreamOptions streamOptions;
    private final List<String> stop;
    private final Integer maxTokens;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final String user;
    private final Integer seed;
    private final List<Tool> tools;
    private final Object toolChoice;
    private final Boolean parallelToolCalls;

    private ChatCompletionRequest(Builder builder) {
        this.model = builder.model;
        this.messages = builder.messages;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.n = builder.n;
        this.stream = builder.stream;
        this.streamOptions = builder.streamOptions;
        this.stop = builder.stop;
        this.maxTokens = builder.maxTokens;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.user = builder.user;
        this.seed = builder.seed;
        this.tools = builder.tools;
        this.toolChoice = builder.toolChoice;
        this.parallelToolCalls = builder.parallelToolCalls;
    }

    public String getModel() {
        return this.model;
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public String getUser() {
        return this.user;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String model;
        private List<Message> messages;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private StreamOptions streamOptions;
        private List<String> stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private String user;
        private Integer seed;
        private List<Tool> tools;
        private Object toolChoice;
        private Boolean parallelToolCalls;

        private Builder() {
        }

        public Builder from(ChatCompletionRequest request) {
            this.model(request.getModel());
            this.messages(request.getMessages());
            this.temperature(request.getTemperature());
            this.topP(request.getTopP());
            this.n(request.getN());
            this.stream(request.getStream());
            this.streamOptions(request.getStreamOptions());
            this.stop(request.getStop());
            this.maxTokens(request.getMaxTokens());
            this.presencePenalty(request.getPresencePenalty());
            this.frequencyPenalty(request.getFrequencyPenalty());
            this.user(request.getUser());
            this.seed(request.getSeed());
            this.tools(request.getTools());
            this.toolChoice(request.getToolChoice());
            this.parallelToolCalls(request.getParallelToolCalls());
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder messages(List<Message> val) {
            this.messages = val;
            return this;
        }

        public Builder temperature(Double val) {
            this.temperature = val;
            return this;
        }

        public Builder topP(Double val) {
            this.topP = val;
            return this;
        }

        public Builder n(Integer val) {
            this.n = val;
            return this;
        }

        public Builder stream(Boolean val) {
            this.stream = val;
            return this;
        }

        public Builder streamOptions(StreamOptions val) {
            this.streamOptions = val;
            return this;
        }

        public Builder stop(List<String> val) {
            this.stop = val;
            return this;
        }

        public Builder maxTokens(Integer val) {
            this.maxTokens = val;
            return this;
        }

        public Builder presencePenalty(Double val) {
            this.presencePenalty = val;
            return this;
        }

        public Builder frequencyPenalty(Double val) {
            this.frequencyPenalty = val;
            return this;
        }

        public Builder user(String val) {
            this.user = val;
            return this;
        }

        public Builder seed(Integer val) {
            this.seed = val;
            return this;
        }

        public Builder tools(List<Tool> val) {
            this.tools = val;
            return this;
        }

        public Builder toolChoice(Object val) {
            this.toolChoice = val;
            return this;
        }

        public Builder parallelToolCalls(Boolean val) {
            this.parallelToolCalls = val;
            return this;
        }

        public ChatCompletionRequest build() {
            return new ChatCompletionRequest(this);
        }
    }
}

