/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.chat.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.chat.Role;
import dev.langchain4j.community.model.xinference.client.chat.message.Message;
import dev.langchain4j.community.model.xinference.client.chat.message.ToolCall;
import java.util.List;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class AssistantMessage
implements Message {
    private final Role role = Role.ASSISTANT;
    private final String content;
    private final List<ToolCall> toolCalls;

    private AssistantMessage(Builder builder) {
        this.content = builder.content;
        this.toolCalls = builder.toolCalls;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<ToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public static AssistantMessage of(String content, ToolCall ... toolCalls) {
        return AssistantMessage.builder().content(content).toolCalls(List.of(toolCalls)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String content;
        private List<ToolCall> toolCalls;

        private Builder() {
        }

        public Builder content(String val) {
            this.content = val;
            return this;
        }

        public Builder toolCalls(List<ToolCall> val) {
            this.toolCalls = val;
            return this;
        }

        public AssistantMessage build() {
            return new AssistantMessage(this);
        }
    }
}

