/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.chat.message;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.chat.Role;
import dev.langchain4j.community.model.xinference.client.chat.message.Message;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class ToolMessage
implements Message {
    private final Role role = Role.TOOL;
    private final String content;
    private final String toolCallId;

    private ToolMessage(Builder builder) {
        this.content = builder.content;
        this.toolCallId = builder.toolCallId;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getToolCallId() {
        return this.toolCallId;
    }

    public static ToolMessage of(String toolCallId, String content) {
        return ToolMessage.builder().content(content).toolCallId(toolCallId).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String content;
        private String toolCallId;

        private Builder() {
        }

        public Builder content(String val) {
            this.content = val;
            return this;
        }

        public Builder toolCallId(String val) {
            this.toolCallId = val;
            return this;
        }

        public ToolMessage build() {
            return new ToolMessage(this);
        }
    }
}

