/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.completion;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.shared.StreamOptions;
import java.util.List;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class CompletionRequest {
    private final String model;
    private final String prompt;
    private final Integer maxTokens;
    private final Double temperature;
    private final Double topP;
    private final Integer n;
    private final Boolean stream;
    private final StreamOptions streamOptions;
    private final Integer logprobs;
    private final Boolean echo;
    private final List<String> stop;
    private final Double presencePenalty;
    private final Double frequencyPenalty;
    private final String user;

    private CompletionRequest(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.maxTokens = builder.maxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.n = builder.n;
        this.stream = builder.stream;
        this.streamOptions = builder.streamOptions;
        this.logprobs = builder.logprobs;
        this.echo = builder.echo;
        this.stop = builder.stop;
        this.presencePenalty = builder.presencePenalty;
        this.frequencyPenalty = builder.frequencyPenalty;
        this.user = builder.user;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public StreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public Boolean getEcho() {
        return this.echo;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public String getUser() {
        return this.user;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String model;
        private String prompt;
        private Integer maxTokens;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private StreamOptions streamOptions;
        private Integer logprobs;
        private Boolean echo;
        private List<String> stop;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private String user;

        private Builder() {
        }

        public Builder from(CompletionRequest request) {
            this.model(request.getModel());
            this.prompt(request.getPrompt());
            this.maxTokens(request.getMaxTokens());
            this.temperature(request.getTemperature());
            this.topP(request.getTopP());
            this.n(request.getN());
            this.stream(request.getStream());
            this.streamOptions(request.getStreamOptions());
            this.logprobs(request.getLogprobs());
            this.echo(request.getEcho());
            this.stop(request.getStop());
            this.presencePenalty(request.getPresencePenalty());
            this.frequencyPenalty(request.getFrequencyPenalty());
            this.user(request.getUser());
            return this;
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder prompt(String val) {
            this.prompt = val;
            return this;
        }

        public Builder maxTokens(Integer val) {
            this.maxTokens = val;
            return this;
        }

        public Builder temperature(Double val) {
            this.temperature = val;
            return this;
        }

        public Builder topP(Double val) {
            this.topP = val;
            return this;
        }

        public Builder n(Integer val) {
            this.n = val;
            return this;
        }

        public Builder stream(Boolean val) {
            this.stream = val;
            return this;
        }

        public Builder streamOptions(StreamOptions val) {
            this.streamOptions = val;
            return this;
        }

        public Builder logprobs(Integer val) {
            this.logprobs = val;
            return this;
        }

        public Builder echo(Boolean val) {
            this.echo = val;
            return this;
        }

        public Builder stop(List<String> val) {
            this.stop = val;
            return this;
        }

        public Builder presencePenalty(Double val) {
            this.presencePenalty = val;
            return this;
        }

        public Builder frequencyPenalty(Double val) {
            this.frequencyPenalty = val;
            return this;
        }

        public Builder user(String val) {
            this.user = val;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this);
        }
    }
}

