/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.xinference.client.image;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.community.model.xinference.client.image.ResponseFormat;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class ImageRequest {
    private final String model;
    private final String prompt;
    private final String negativePrompt;
    private final Integer n;
    private final ResponseFormat responseFormat;
    private final String size;
    private final String kwargs;
    private final String user;

    private ImageRequest(Builder builder) {
        this.model = builder.model;
        this.prompt = builder.prompt;
        this.negativePrompt = builder.negativePrompt;
        this.n = builder.n;
        this.responseFormat = builder.responseFormat;
        this.size = builder.size;
        this.kwargs = builder.kwargs;
        this.user = builder.user;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public Integer getN() {
        return this.n;
    }

    public ResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public String getSize() {
        return this.size;
    }

    public String getKwargs() {
        return this.kwargs;
    }

    public String getUser() {
        return this.user;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String model;
        private String prompt;
        private String negativePrompt;
        private Integer n = 1;
        private ResponseFormat responseFormat;
        private String size;
        private String kwargs;
        private String user;

        private Builder() {
        }

        public Builder model(String val) {
            this.model = val;
            return this;
        }

        public Builder prompt(String val) {
            this.prompt = val;
            return this;
        }

        public Builder negativePrompt(String val) {
            this.negativePrompt = val;
            return this;
        }

        public Builder n(Integer val) {
            this.n = val;
            return this;
        }

        public Builder responseFormat(ResponseFormat val) {
            this.responseFormat = val;
            return this;
        }

        public Builder size(String val) {
            this.size = val;
            return this;
        }

        public Builder kwargs(String val) {
            this.kwargs = val;
            return this;
        }

        public Builder user(String val) {
            this.user = val;
            return this;
        }

        public ImageRequest build() {
            return new ImageRequest(this);
        }
    }
}

