/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.community.model.zhipu.InternalZhipuAiHelper;
import dev.langchain4j.community.model.zhipu.ZhipuAiClient;
import dev.langchain4j.community.model.zhipu.ZhipuAiException;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionResponse;
import dev.langchain4j.community.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.community.model.zhipu.spi.ZhipuAiChatModelBuilderFactory;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ZhipuAiChatModel
implements ChatModel {
    private final ZhipuAiClient client;
    private final List<ChatModelListener> listeners;
    private final Integer maxRetries;
    private final ChatRequestParameters defaultRequestParameters;

    public ZhipuAiChatModel(String baseUrl, String apiKey, Double temperature, Double topP, String model, List<String> stops, Integer maxRetries, Integer maxToken, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.listeners = Utils.copy(listeners);
        this.client = ZhipuAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/")).apiKey(apiKey).callTimeout(callTimeout).connectTimeout(connectTimeout).writeTimeout(writeTimeout).readTimeout(readTimeout).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.defaultRequestParameters = ChatRequestParameters.builder().temperature((Double)Utils.getOrDefault((Object)temperature, (Object)0.7)).topP(topP).stopSequences(stops).modelName((String)ValidationUtils.ensureNotNull((Object)model, (String)"model")).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxToken, (Object)512)).build();
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ChatResponse doChat(ChatRequest request) {
        List messages = request.messages();
        List toolSpecifications = request.toolSpecifications();
        ChatRequestParameters parameters = request.parameters();
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(parameters.modelName()).messages(InternalZhipuAiHelper.toZhipuAiMessages(messages)).maxTokens(parameters.maxOutputTokens()).stop(parameters.stopSequences()).stream(false).temperature(parameters.temperature()).topP(parameters.topP()).toolChoice(ToolChoiceMode.AUTO);
        if (!Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            requestBuilder.tools(InternalZhipuAiHelper.toTools(toolSpecifications));
        }
        ChatCompletionRequest completionRequest = requestBuilder.build();
        ChatCompletionResponse completionResponse = (ChatCompletionResponse)RetryUtils.withRetry(() -> this.client.chatCompletion(completionRequest), (int)this.maxRetries);
        FinishReason finishReason = InternalZhipuAiHelper.finishReasonFrom(completionResponse.getChoices().get(0).getFinishReason());
        ChatResponse response = ChatResponse.builder().aiMessage(InternalZhipuAiHelper.aiMessageFrom(completionResponse)).tokenUsage(InternalZhipuAiHelper.tokenUsageFrom(completionResponse.getUsage())).finishReason(finishReason).id(completionResponse.getId()).modelName(completionResponse.getModel()).build();
        if (!InternalZhipuAiHelper.isSuccessFinishReason(finishReason)) {
            throw new ZhipuAiException(response.aiMessage().text());
        }
        return response;
    }

    public static ZhipuAiChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiChatModelBuilderFactory factories = (ZhipuAiChatModelBuilderFactory)iterator.next();
            return (ZhipuAiChatModelBuilder)factories.get();
        }
        return new ZhipuAiChatModelBuilder();
    }

    public static class ZhipuAiChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private String model;
        private List<String> stops;
        private Integer maxRetries;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Duration callTimeout;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        public ZhipuAiChatModelBuilder model(ChatCompletionModel model) {
            this.model = model.toString();
            return this;
        }

        public ZhipuAiChatModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public ZhipuAiChatModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public ZhipuAiChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Deprecated(since="1.0.0-beta4", forRemoval=true)
        public ZhipuAiChatModelBuilder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public ZhipuAiChatModelBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ZhipuAiChatModelBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Deprecated(since="1.0.0-beta4", forRemoval=true)
        public ZhipuAiChatModelBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ZhipuAiChatModel build() {
            return new ZhipuAiChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.model, this.stops, this.maxRetries, this.maxToken, this.logRequests, this.logResponses, this.listeners, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }
    }
}

