/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import dev.langchain4j.community.model.zhipu.InternalZhipuAiHelper;
import dev.langchain4j.community.model.zhipu.ZhipuAiClient;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionModel;
import dev.langchain4j.community.model.zhipu.chat.ChatCompletionRequest;
import dev.langchain4j.community.model.zhipu.chat.ToolChoiceMode;
import dev.langchain4j.community.model.zhipu.spi.ZhipuAiStreamingChatModelBuilderFactory;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.spi.ServiceHelper;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ZhipuAiStreamingChatModel
implements StreamingChatModel {
    private final ZhipuAiClient client;
    private final List<ChatModelListener> listeners;
    private final ChatRequestParameters defaultRequestParameters;

    public ZhipuAiStreamingChatModel(String baseUrl, String apiKey, Double temperature, Double topP, List<String> stops, String model, Integer maxToken, Boolean logRequests, Boolean logResponses, List<ChatModelListener> listeners, Duration callTimeout, Duration connectTimeout, Duration readTimeout, Duration writeTimeout) {
        this.listeners = Utils.copy(listeners);
        this.client = ZhipuAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://open.bigmodel.cn/")).apiKey(apiKey).callTimeout(callTimeout).connectTimeout(connectTimeout).writeTimeout(writeTimeout).readTimeout(readTimeout).logRequests((Boolean)Utils.getOrDefault((Object)logRequests, (Object)false)).logResponses((Boolean)Utils.getOrDefault((Object)logResponses, (Object)false)).build();
        this.defaultRequestParameters = ChatRequestParameters.builder().temperature((Double)Utils.getOrDefault((Object)temperature, (Object)0.7)).topP(topP).stopSequences(stops).modelName((String)ValidationUtils.ensureNotNull((Object)model, (String)"model")).maxOutputTokens((Integer)Utils.getOrDefault((Object)maxToken, (Object)512)).build();
    }

    public ChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public void doChat(ChatRequest request, StreamingChatResponseHandler handler) {
        List messages = request.messages();
        List toolSpecifications = request.toolSpecifications();
        ChatRequestParameters parameters = request.parameters();
        ChatCompletionRequest.Builder requestBuilder = ChatCompletionRequest.builder().model(parameters.modelName()).messages(InternalZhipuAiHelper.toZhipuAiMessages(messages)).maxTokens(parameters.maxOutputTokens()).stop(parameters.stopSequences()).stream(true).temperature(parameters.temperature()).topP(parameters.topP()).toolChoice(ToolChoiceMode.AUTO);
        if (!Utils.isNullOrEmpty((Collection)toolSpecifications)) {
            requestBuilder.tools(InternalZhipuAiHelper.toTools(toolSpecifications));
        }
        ChatCompletionRequest completionRequest = requestBuilder.build();
        this.client.streamingChatCompletion(completionRequest, handler);
    }

    public static ZhipuAiStreamingChatModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(ZhipuAiStreamingChatModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            ZhipuAiStreamingChatModelBuilderFactory factories = (ZhipuAiStreamingChatModelBuilderFactory)iterator.next();
            return (ZhipuAiStreamingChatModelBuilder)factories.get();
        }
        return new ZhipuAiStreamingChatModelBuilder();
    }

    public static class ZhipuAiStreamingChatModelBuilder {
        private String baseUrl;
        private String apiKey;
        private Double temperature;
        private Double topP;
        private List<String> stops;
        private String model;
        private Integer maxToken;
        private Boolean logRequests;
        private Boolean logResponses;
        private List<ChatModelListener> listeners;
        private Duration callTimeout;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;

        public ZhipuAiStreamingChatModelBuilder model(ChatCompletionModel model) {
            this.model = model.toString();
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder stops(List<String> stops) {
            this.stops = stops;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder maxToken(Integer maxToken) {
            this.maxToken = maxToken;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        @Deprecated(since="1.0.0-beta4", forRemoval=true)
        public ZhipuAiStreamingChatModelBuilder callTimeout(Duration callTimeout) {
            this.callTimeout = callTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModelBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Deprecated(since="1.0.0-beta4", forRemoval=true)
        public ZhipuAiStreamingChatModelBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public ZhipuAiStreamingChatModel build() {
            return new ZhipuAiStreamingChatModel(this.baseUrl, this.apiKey, this.temperature, this.topP, this.stops, this.model, this.maxToken, this.logRequests, this.logResponses, this.listeners, this.callTimeout, this.connectTimeout, this.readTimeout, this.writeTimeout);
        }
    }
}

