package dev.langchain4j.agent.tool;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Java methods annotated with @Tool are considered tools that LLM can use.
 */
@Retention(RUNTIME)
@Target({METHOD})
public @interface Tool {

    /**
     * Name of the tool. If not provided, method name will be used.
     */
    String name() default "";

    /**
     * Description of the tool.
     * It should be clear and descriptive to allow LLM to understand the tool's purpose and its intended use.
     */
    String[] value() default "";
}
