/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import java.util.Objects;

public class ToolExecutionResultMessage
extends ChatMessage {
    private final String toolName;

    public ToolExecutionResultMessage(String toolName, String toolExecutionResult) {
        super(toolExecutionResult);
        this.toolName = toolName;
    }

    public String toolName() {
        return this.toolName;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.TOOL_EXECUTION_RESULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolExecutionResultMessage that = (ToolExecutionResultMessage)o;
        return Objects.equals(this.toolName, that.toolName) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.toolName, this.text);
    }

    public String toString() {
        return "ToolExecutionResultMessage { toolName = " + Utils.quoted(this.toolName) + " text = " + Utils.quoted(this.text) + " }";
    }

    public static ToolExecutionResultMessage from(String toolName, String toolExecutionResult) {
        return new ToolExecutionResultMessage(toolName, toolExecutionResult);
    }

    public static ToolExecutionResultMessage toolExecutionResultMessage(String toolName, String toolExecutionResult) {
        return ToolExecutionResultMessage.from(toolName, toolExecutionResult);
    }
}

