/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.ValidationUtils;

public class Similarity {
    public static double cosine(float[] a, float[] b) {
        ValidationUtils.ensureNotNull(a, "a");
        ValidationUtils.ensureNotNull(b, "b");
        if (a.length != b.length) {
            throw Exceptions.illegalArgument("Length of vector a (%s) must be equal to the length of vector b (%s)", a.length, b.length);
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        for (int i = 0; i < a.length; ++i) {
            dotProduct += (double)(a[i] * b[i]);
            normA += (double)(a[i] * a[i]);
            normB += (double)(b[i] * b[i]);
        }
        return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }
}

