/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.input.DefaultPromptTemplateFactory;
import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.prompt.PromptTemplateFactory;
import java.time.Clock;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PromptTemplate {
    private static final PromptTemplateFactory FACTORY = ServiceHelper.loadService(PromptTemplateFactory.class, DefaultPromptTemplateFactory::new);
    static final String CURRENT_DATE = "current_date";
    static final String CURRENT_TIME = "current_time";
    static final String CURRENT_DATE_TIME = "current_date_time";
    private final String templateString;
    private final PromptTemplateFactory.Template template;
    private final Clock clock;

    public PromptTemplate(String template) {
        this(template, Clock.systemDefaultZone());
    }

    PromptTemplate(String template, Clock clock) {
        this.templateString = ValidationUtils.ensureNotBlank(template, "template");
        this.template = FACTORY.create(() -> template);
        this.clock = ValidationUtils.ensureNotNull(clock, "clock");
    }

    public String template() {
        return this.templateString;
    }

    public Prompt apply(Object value) {
        return this.apply(Collections.singletonMap("it", value));
    }

    public Prompt apply(Map<String, Object> variables) {
        ValidationUtils.ensureNotNull(variables, "variables");
        return Prompt.from(this.template.render(this.injectDateTimeVariables(variables)));
    }

    private Map<String, Object> injectDateTimeVariables(Map<String, Object> variables) {
        HashMap<String, Object> variablesCopy = new HashMap<String, Object>(variables);
        variablesCopy.put(CURRENT_DATE, LocalDate.now(this.clock));
        variablesCopy.put(CURRENT_TIME, LocalTime.now(this.clock));
        variablesCopy.put(CURRENT_DATE_TIME, LocalDateTime.now(this.clock));
        return variablesCopy;
    }

    public static PromptTemplate from(String template) {
        return new PromptTemplate(template);
    }
}

