/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToolExecutionRequestUtil {
    private static final Pattern TRAILING_COMMA_PATTERN = Pattern.compile(",(\\s*[}\\]])");
    public static final Gson GSON = new Gson();
    public static final Type MAP_TYPE = new TypeToken<Map<String, Object>>(){}.getType();

    private ToolExecutionRequestUtil() {
    }

    public static <T> T argument(ToolExecutionRequest toolExecutionRequest, String name) {
        Map<String, Object> arguments = ToolExecutionRequestUtil.argumentsAsMap(toolExecutionRequest.arguments());
        Object res = arguments.get(name);
        return (T)res;
    }

    public static Map<String, Object> argumentsAsMap(String arguments) {
        return (Map)GSON.fromJson(ToolExecutionRequestUtil.removeTrailingComma(arguments), MAP_TYPE);
    }

    static String removeTrailingComma(String json) {
        if (json == null || json.isEmpty()) {
            return json;
        }
        Matcher matcher = TRAILING_COMMA_PATTERN.matcher(json);
        return matcher.replaceAll("$1");
    }
}

