/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.content;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class Content {
    private final TextSegment textSegment;

    public Content(String text) {
        this(TextSegment.from(text));
    }

    public Content(TextSegment textSegment) {
        this.textSegment = ValidationUtils.ensureNotNull(textSegment, "textSegment");
    }

    public TextSegment textSegment() {
        return this.textSegment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content that = (Content)o;
        return Objects.equals(this.textSegment, that.textSegment);
    }

    public int hashCode() {
        return Objects.hash(this.textSegment);
    }

    public String toString() {
        return "Content { textSegment = " + String.valueOf(this.textSegment) + " }";
    }

    public static Content from(String text) {
        return new Content(text);
    }

    public static Content from(TextSegment textSegment) {
        return new Content(textSegment);
    }
}

