/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.Response;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public interface ChatLanguageModel {
    @Experimental
    default public ChatResponse chat(ChatRequest chatRequest) {
        Response<AiMessage> response;
        ChatRequestParameters parameters = chatRequest.parameters();
        ChatLanguageModel.validate(parameters);
        ChatLanguageModel.validate(parameters.toolChoice());
        ChatLanguageModel.validate(parameters.responseFormat());
        List<ToolSpecification> toolSpecifications = parameters.toolSpecifications();
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            response = this.generate(chatRequest.messages());
        } else if (parameters.toolChoice() == ToolChoice.REQUIRED) {
            if (toolSpecifications.size() != 1) {
                throw new UnsupportedFeatureException("%s.%s is currently supported only when there is a single tool".formatted(ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
            }
            response = this.generate(chatRequest.messages(), toolSpecifications.get(0));
        } else {
            response = this.generate(chatRequest.messages(), toolSpecifications);
        }
        return ChatResponse.builder().aiMessage(response.content()).metadata(((ChatResponseMetadata.Builder)((ChatResponseMetadata.Builder)ChatResponseMetadata.builder().tokenUsage(response.tokenUsage())).finishReason(response.finishReason())).build()).build();
    }

    public static void validate(ChatRequestParameters parameters) {
        String errorTemplate = "%s is not supported yet by this model provider";
        if (parameters.modelName() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'modelName' parameter"));
        }
        if (parameters.temperature() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'temperature' parameter"));
        }
        if (parameters.topP() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'topP' parameter"));
        }
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'topK' parameter"));
        }
        if (parameters.frequencyPenalty() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'frequencyPenalty' parameter"));
        }
        if (parameters.presencePenalty() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'presencePenalty' parameter"));
        }
        if (parameters.maxOutputTokens() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'maxOutputTokens' parameter"));
        }
        if (parameters.stopSequences() != null) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("'stopSequences' parameter"));
        }
    }

    public static void validate(ToolChoice toolChoice) {
        if (toolChoice == ToolChoice.REQUIRED) {
            throw new UnsupportedFeatureException("%s.%s is not supported yet by this model provider".formatted(ToolChoice.class.getSimpleName(), ToolChoice.REQUIRED.name()));
        }
    }

    public static void validate(ResponseFormat responseFormat) {
        String errorTemplate = "%s is not supported yet by this model provider";
        if (responseFormat != null && responseFormat.type() == ResponseFormatType.JSON) {
            throw new UnsupportedFeatureException(errorTemplate.formatted("JSON response format"));
        }
    }

    @Experimental
    default public String chat(String userMessage) {
        ChatRequest chatRequest = ChatRequest.builder().messages(UserMessage.from(userMessage)).build();
        ChatResponse chatResponse = this.chat(chatRequest);
        return chatResponse.aiMessage().text();
    }

    @Experimental
    default public ChatRequestParameters defaultRequestParameters() {
        return null;
    }

    @Experimental
    default public Set<Capability> supportedCapabilities() {
        return Set.of();
    }

    default public String generate(String userMessage) {
        return this.generate(UserMessage.from(userMessage)).content().text();
    }

    default public Response<AiMessage> generate(ChatMessage ... messages) {
        return this.generate(Arrays.asList(messages));
    }

    public Response<AiMessage> generate(List<ChatMessage> var1);

    default public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        throw new UnsupportedFeatureException("tools are currently not supported by " + this.getClass().getSimpleName());
    }

    default public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new UnsupportedFeatureException("tools and tool choice are currently not supported by " + this.getClass().getSimpleName());
    }
}

