/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request.json;

import dev.langchain4j.internal.TypeUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonReferenceSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class JsonSchemaElementHelper {
    public static JsonSchemaElement jsonSchemaElementFrom(Class<?> clazz) {
        return JsonSchemaElementHelper.jsonSchemaElementFrom(clazz, clazz, null, new LinkedHashMap());
    }

    public static JsonSchemaElement jsonSchemaElementFrom(Class<?> clazz, Type type, String fieldDescription, Map<Class<?>, VisitedClassMetadata> visited) {
        if (TypeUtils.isJsonString(clazz)) {
            return JsonStringSchema.builder().description(fieldDescription).build();
        }
        if (TypeUtils.isJsonInteger(clazz)) {
            return JsonIntegerSchema.builder().description(fieldDescription).build();
        }
        if (TypeUtils.isJsonNumber(clazz)) {
            return JsonNumberSchema.builder().description(fieldDescription).build();
        }
        if (TypeUtils.isJsonBoolean(clazz)) {
            return JsonBooleanSchema.builder().description(fieldDescription).build();
        }
        if (clazz.isEnum()) {
            return JsonEnumSchema.builder().enumValues(Arrays.stream(clazz.getEnumConstants()).map(Object::toString).toList()).description(Optional.ofNullable(fieldDescription).orElse(JsonSchemaElementHelper.descriptionFrom(clazz))).build();
        }
        if (clazz.isArray()) {
            return JsonArraySchema.builder().items(JsonSchemaElementHelper.jsonSchemaElementFrom(clazz.getComponentType(), null, null, visited)).description(fieldDescription).build();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return JsonArraySchema.builder().items(JsonSchemaElementHelper.jsonSchemaElementFrom(JsonSchemaElementHelper.getActualType(type), null, null, visited)).description(fieldDescription).build();
        }
        return JsonSchemaElementHelper.jsonObjectOrReferenceSchemaFrom(clazz, fieldDescription, visited, false);
    }

    public static JsonSchemaElement jsonObjectOrReferenceSchemaFrom(Class<?> type, String description, Map<Class<?>, VisitedClassMetadata> visited, boolean setDefinitions) {
        if (visited.containsKey(type) && JsonSchemaElementHelper.isCustomClass(type)) {
            VisitedClassMetadata visitedClassMetadata2 = visited.get(type);
            JsonSchemaElement jsonSchemaElement = visitedClassMetadata2.jsonSchemaElement;
            if (jsonSchemaElement instanceof JsonReferenceSchema) {
                visitedClassMetadata2.recursionDetected = true;
            }
            return jsonSchemaElement;
        }
        String reference = Utils.generateUUIDFrom(type.getName());
        JsonReferenceSchema jsonReferenceSchema = JsonReferenceSchema.builder().reference(reference).build();
        visited.put(type, new VisitedClassMetadata(jsonReferenceSchema, reference, false));
        LinkedHashMap<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        for (Field field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (Modifier.isStatic(field.getModifiers()) || fieldName.equals("__$hits$__") || fieldName.startsWith("this$")) continue;
            String fieldDescription = JsonSchemaElementHelper.descriptionFrom(field);
            JsonSchemaElement jsonSchemaElement = JsonSchemaElementHelper.jsonSchemaElementFrom(field.getType(), field.getGenericType(), fieldDescription, visited);
            properties.put(fieldName, jsonSchemaElement);
        }
        JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(Optional.ofNullable(description).orElse(JsonSchemaElementHelper.descriptionFrom(type))).properties(properties).required(new ArrayList<String>(properties.keySet()));
        visited.get(type).jsonSchemaElement = builder.build();
        if (setDefinitions) {
            LinkedHashMap<String, JsonSchemaElement> definitions = new LinkedHashMap<String, JsonSchemaElement>();
            visited.forEach((clazz, visitedClassMetadata) -> {
                if (visitedClassMetadata.recursionDetected) {
                    definitions.put(visitedClassMetadata.reference, visitedClassMetadata.jsonSchemaElement);
                }
            });
            if (!definitions.isEmpty()) {
                builder.definitions(definitions);
            }
        }
        return builder.build();
    }

    private static String descriptionFrom(Field field) {
        return JsonSchemaElementHelper.descriptionFrom(field.getAnnotation(Description.class));
    }

    private static String descriptionFrom(Class<?> type) {
        return JsonSchemaElementHelper.descriptionFrom(type.getAnnotation(Description.class));
    }

    private static String descriptionFrom(Description description) {
        if (description == null) {
            return null;
        }
        return String.join((CharSequence)" ", description.value());
    }

    private static Class<?> getActualType(Type type) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        if (type instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    static boolean isCustomClass(Class<?> clazz) {
        String packageName;
        return clazz.getPackage() == null || !(packageName = clazz.getPackage().getName()).startsWith("java.") && !packageName.startsWith("javax.") && !packageName.startsWith("jdk.") && !packageName.startsWith("sun.") && !packageName.startsWith("com.sun.");
    }

    public static Map<String, Map<String, Object>> toMap(Map<String, JsonSchemaElement> properties) {
        return JsonSchemaElementHelper.toMap(properties, false);
    }

    public static Map<String, Map<String, Object>> toMap(Map<String, JsonSchemaElement> properties, boolean strict) {
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>();
        properties.forEach((property, value) -> map.put((String)property, JsonSchemaElementHelper.toMap(value, strict)));
        return map;
    }

    public static Map<String, Object> toMap(JsonSchemaElement jsonSchemaElement) {
        return JsonSchemaElementHelper.toMap(jsonSchemaElement, false);
    }

    public static Map<String, Object> toMap(JsonSchemaElement jsonSchemaElement, boolean strict) {
        if (jsonSchemaElement instanceof JsonObjectSchema) {
            JsonObjectSchema jsonObjectSchema = (JsonObjectSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "object");
            if (jsonObjectSchema.description() != null) {
                properties.put("description", jsonObjectSchema.description());
            }
            properties.put("properties", JsonSchemaElementHelper.toMap(jsonObjectSchema.properties(), strict));
            if (jsonObjectSchema.required() != null) {
                properties.put("required", jsonObjectSchema.required());
            }
            if (strict) {
                properties.put("additionalProperties", false);
            }
            if (jsonObjectSchema.definitions() != null) {
                properties.put("$defs", JsonSchemaElementHelper.toMap(jsonObjectSchema.definitions(), strict));
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonArraySchema) {
            JsonArraySchema jsonArraySchema = (JsonArraySchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "array");
            if (jsonArraySchema.description() != null) {
                properties.put("description", jsonArraySchema.description());
            }
            properties.put("items", JsonSchemaElementHelper.toMap(jsonArraySchema.items(), strict));
            return properties;
        }
        if (jsonSchemaElement instanceof JsonEnumSchema) {
            JsonEnumSchema jsonEnumSchema = (JsonEnumSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "string");
            if (jsonEnumSchema.description() != null) {
                properties.put("description", jsonEnumSchema.description());
            }
            properties.put("enum", jsonEnumSchema.enumValues());
            return properties;
        }
        if (jsonSchemaElement instanceof JsonStringSchema) {
            JsonStringSchema jsonStringSchema = (JsonStringSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "string");
            if (jsonStringSchema.description() != null) {
                properties.put("description", jsonStringSchema.description());
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonIntegerSchema) {
            JsonIntegerSchema jsonIntegerSchema = (JsonIntegerSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "integer");
            if (jsonIntegerSchema.description() != null) {
                properties.put("description", jsonIntegerSchema.description());
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonNumberSchema) {
            JsonNumberSchema jsonNumberSchema = (JsonNumberSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "number");
            if (jsonNumberSchema.description() != null) {
                properties.put("description", jsonNumberSchema.description());
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonBooleanSchema) {
            JsonBooleanSchema jsonBooleanSchema = (JsonBooleanSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("type", "boolean");
            if (jsonBooleanSchema.description() != null) {
                properties.put("description", jsonBooleanSchema.description());
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonReferenceSchema) {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            String reference = ((JsonReferenceSchema)jsonSchemaElement).reference();
            if (reference != null) {
                properties.put("$ref", "#/$defs/" + reference);
            }
            return properties;
        }
        if (jsonSchemaElement instanceof JsonAnyOfSchema) {
            JsonAnyOfSchema jsonAnyOfSchema = (JsonAnyOfSchema)jsonSchemaElement;
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            if (jsonAnyOfSchema.description() != null) {
                properties.put("description", jsonAnyOfSchema.description());
            }
            List<Map> anyOf = jsonAnyOfSchema.anyOf().stream().map(element -> JsonSchemaElementHelper.toMap(element, strict)).toList();
            properties.put("anyOf", anyOf);
            return properties;
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(jsonSchemaElement.getClass()));
    }

    public static class VisitedClassMetadata {
        public JsonSchemaElement jsonSchemaElement;
        public String reference;
        public boolean recursionDetected;

        public VisitedClassMetadata(JsonSchemaElement jsonSchemaElement, String reference, boolean recursionDetected) {
            this.jsonSchemaElement = jsonSchemaElement;
            this.reference = reference;
            this.recursionDetected = recursionDetected;
        }
    }
}

