/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.listener;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import java.util.Map;

@Experimental
public class ChatModelResponseContext {
    private final ChatResponse chatResponse;
    @Deprecated(forRemoval=true)
    private final ChatModelResponse response;
    private final ChatRequest chatRequest;
    @Deprecated(forRemoval=true)
    private final ChatModelRequest request;
    private final ModelProvider modelProvider;
    private final Map<Object, Object> attributes;

    public ChatModelResponseContext(ChatResponse chatResponse, ChatRequest chatRequest, ModelProvider modelProvider, Map<Object, Object> attributes) {
        this.chatResponse = ValidationUtils.ensureNotNull(chatResponse, "chatResponse");
        this.response = ChatModelResponse.fromChatResponse(chatResponse);
        this.chatRequest = ValidationUtils.ensureNotNull(chatRequest, "chatRequest");
        this.request = ChatModelRequest.fromChatRequest(chatRequest);
        this.modelProvider = modelProvider;
        this.attributes = ValidationUtils.ensureNotNull(attributes, "attributes");
    }

    @Deprecated(forRemoval=true)
    public ChatModelResponseContext(ChatResponse chatResponse, ChatRequest chatRequest, Map<Object, Object> attributes) {
        this(chatResponse, chatRequest, ModelProvider.OTHER, attributes);
    }

    @Deprecated(forRemoval=true)
    public ChatModelResponseContext(ChatModelResponse response, ChatModelRequest request, Map<Object, Object> attributes) {
        this.chatResponse = ChatModelResponse.toChatResponse(response);
        this.response = ValidationUtils.ensureNotNull(response, "response");
        this.chatRequest = ChatModelRequest.toChatRequest(request);
        this.request = ValidationUtils.ensureNotNull(request, "request");
        this.modelProvider = ModelProvider.OTHER;
        this.attributes = ValidationUtils.ensureNotNull(attributes, "attributes");
    }

    @Deprecated(forRemoval=true)
    public ChatModelResponseContext(ChatModelResponse response, ChatModelRequest request, ModelProvider modelProvider, Map<Object, Object> attributes) {
        this.chatResponse = ChatModelResponse.toChatResponse(response);
        this.response = ValidationUtils.ensureNotNull(response, "response");
        this.chatRequest = ChatModelRequest.toChatRequest(request);
        this.request = ValidationUtils.ensureNotNull(request, "request");
        this.modelProvider = modelProvider;
        this.attributes = ValidationUtils.ensureNotNull(attributes, "attributes");
    }

    public ChatResponse chatResponse() {
        return this.chatResponse;
    }

    @Deprecated(forRemoval=true)
    public ChatModelResponse response() {
        return this.response;
    }

    public ChatRequest chatRequest() {
        return this.chatRequest;
    }

    @Deprecated(forRemoval=true)
    public ChatModelRequest request() {
        return this.request;
    }

    public ModelProvider modelProvider() {
        return this.modelProvider;
    }

    public Map<Object, Object> attributes() {
        return this.attributes;
    }
}

