/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Experimental
public class ChatRequest {
    private final List<ChatMessage> messages;
    private final ChatRequestParameters parameters;

    protected ChatRequest(Builder builder) {
        this.messages = new ArrayList<ChatMessage>(ValidationUtils.ensureNotEmpty(builder.messages, "messages"));
        DefaultChatRequestParameters.Builder<?> parametersBuilder = ChatRequestParameters.builder();
        if (!Utils.isNullOrEmpty(builder.toolSpecifications)) {
            if (builder.parameters != null) {
                throw new IllegalArgumentException("Cannot set both 'parameters' and 'toolSpecifications' on ChatRequest");
            }
            parametersBuilder.toolSpecifications(builder.toolSpecifications);
        }
        if (builder.responseFormat != null) {
            if (builder.parameters != null) {
                throw new IllegalArgumentException("Cannot set both 'parameters' and 'responseFormat' on ChatRequest");
            }
            parametersBuilder.responseFormat(builder.responseFormat);
        }
        this.parameters = builder.parameters != null ? builder.parameters : parametersBuilder.build();
    }

    public List<ChatMessage> messages() {
        return this.messages;
    }

    @Experimental
    public ChatRequestParameters parameters() {
        return this.parameters;
    }

    @Experimental
    public List<ToolSpecification> toolSpecifications() {
        return this.parameters.toolSpecifications();
    }

    @Experimental
    public ResponseFormat responseFormat() {
        return this.parameters.responseFormat();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatRequest that = (ChatRequest)o;
        return Objects.equals(this.messages, that.messages) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.parameters);
    }

    public String toString() {
        return "ChatRequest { messages = " + String.valueOf(this.messages) + ", parameters = " + String.valueOf(this.parameters) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatMessage> messages;
        private ChatRequestParameters parameters;
        private List<ToolSpecification> toolSpecifications;
        private ResponseFormat responseFormat;

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder messages(ChatMessage ... messages) {
            return this.messages(Arrays.asList(messages));
        }

        @Experimental
        public Builder parameters(ChatRequestParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        @Experimental
        public Builder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        @Experimental
        public Builder toolSpecifications(ToolSpecification ... toolSpecifications) {
            return this.toolSpecifications(Arrays.asList(toolSpecifications));
        }

        @Experimental
        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

