/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonBooleanSchema;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.request.json.JsonStringSchema;
import dev.langchain4j.model.output.structured.Description;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ToolSpecificationsTest
implements WithAssertions {
    ToolSpecificationsTest() {
    }

    private static Method getF() throws NoSuchMethodException {
        return Wrapper.class.getMethod("f", String.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, String[].class, Integer[].class, Boolean[].class, int[].class, boolean[].class, List.class, Set.class, Collection.class, E.class, Person.class, Integer.TYPE, Integer.TYPE);
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return map;
    }

    public static <K, V> Map<K, V> mapOf(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return map;
    }

    @Test
    void tool_specifications_from() {
        List specs = ToolSpecifications.toolSpecificationsFrom((Object)new Wrapper());
        this.assertThat(specs).hasSize(2);
        this.assertThat(specs).extracting(ToolSpecification::name).containsExactlyInAnyOrder((Object[])new String[]{"f", "func_name"});
    }

    @Test
    void tool_specifications_from_with_duplicate_method_names() {
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ToolSpecifications.toolSpecificationsFrom((Object)new InvalidToolsWithDuplicateMethodNames())).withMessage("Tool names must be unique. The tool 'duplicateMethod' appears several times").withNoCause();
    }

    @Test
    void tool_specifications_from_with_duplicate_names() {
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ToolSpecifications.toolSpecificationsFrom((Object)new InvalidToolsWithDuplicateNames())).withMessage("Tool names must be unique. The tool 'duplicate_name' appears several times").withNoCause();
    }

    @Test
    void tool_name_memory_id() throws NoSuchMethodException {
        Method method = Wrapper.class.getMethod("g", String.class);
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("func_name");
        this.assertThat(ts.description()).isNull();
        this.assertThat(ts.parameters()).isNull();
    }

    @Test
    void tool_specification_from() throws NoSuchMethodException {
        Method method = ToolSpecificationsTest.getF();
        ToolSpecification ts = ToolSpecifications.toolSpecificationFrom((Method)method);
        this.assertThat(ts.name()).isEqualTo("f");
        this.assertThat(ts.description()).isEqualTo("line1\nline2");
        this.assertThat(ts.parameters()).isInstanceOf(JsonObjectSchema.class);
        Map properties = ts.parameters().properties();
        this.assertThat(properties).hasSize(29);
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)this.assertThat(properties).containsEntry((Object)"arg0", (Object)JsonStringSchema.builder().description("foo").build())).containsEntry((Object)"arg1", (Object)new JsonBooleanSchema())).containsEntry((Object)"arg2", (Object)JsonBooleanSchema.builder().description("b2").build())).containsEntry((Object)"arg3", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg4", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg5", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg6", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg7", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg8", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg9", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg10", (Object)new JsonIntegerSchema())).containsEntry((Object)"arg11", (Object)JsonIntegerSchema.builder().description("biggy").build())).containsEntry((Object)"arg12", (Object)new JsonNumberSchema())).containsEntry((Object)"arg13", (Object)new JsonNumberSchema())).containsEntry((Object)"arg14", (Object)new JsonNumberSchema())).containsEntry((Object)"arg15", (Object)new JsonNumberSchema())).containsEntry((Object)"arg16", (Object)JsonNumberSchema.builder().description("bigger").build())).containsEntry((Object)"arg17", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonStringSchema()).build())).containsEntry((Object)"arg18", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonIntegerSchema()).build())).containsEntry((Object)"arg19", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonBooleanSchema()).build())).containsEntry((Object)"arg20", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonIntegerSchema()).build())).containsEntry((Object)"arg21", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonBooleanSchema()).build())).containsEntry((Object)"arg22", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonIntegerSchema()).build())).containsEntry((Object)"arg23", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonNumberSchema()).build())).containsEntry((Object)"arg24", (Object)JsonArraySchema.builder().items((JsonSchemaElement)new JsonStringSchema()).build())).containsEntry((Object)"arg25", (Object)JsonEnumSchema.builder().enumValues(new String[]{"A", "B", "C"}).build())).containsEntry((Object)"arg27", (Object)JsonIntegerSchema.builder().description("optional").build())).containsEntry((Object)"arg28", (Object)JsonIntegerSchema.builder().description("required").build());
        this.assertThat(ts.parameters().required()).containsExactly((Object[])new String[]{"arg0", "arg1", "arg2", "arg3", "arg4", "arg5", "arg6", "arg7", "arg8", "arg9", "arg10", "arg11", "arg12", "arg13", "arg14", "arg15", "arg16", "arg17", "arg18", "arg19", "arg20", "arg21", "arg22", "arg23", "arg24", "arg25", "arg26", "arg28"});
    }

    @Test
    void object_used_multiple_times() {
        List toolSpecifications = ToolSpecifications.toolSpecificationsFrom(CustomerRegistration.class);
        this.assertThat(toolSpecifications).hasSize(1);
        ToolSpecification toolSpecification = (ToolSpecification)toolSpecifications.get(0);
        this.assertThat(toolSpecification.name()).isEqualTo("registerCustomer");
        this.assertThat(toolSpecification.description()).isEqualTo("register a new customer");
        this.assertThat(toolSpecification.parameters()).isEqualTo((Object)JsonObjectSchema.builder().addProperty("arg0", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("name").addProperty("billingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("street").addStringProperty("city").required(new String[]{"street", "city"}).build()).addProperty("shippingAddress", (JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("street").addStringProperty("city").required(new String[]{"street", "city"}).build()).required(new String[]{"name", "billingAddress", "shippingAddress"}).build()).required(new String[]{"arg0"}).build());
    }

    public static class Wrapper {
        @Tool(value={"line1", "line2"})
        public int f(@P(value="foo") String p0, boolean p1, @P(value="b2") Boolean p2, byte p3, Byte p4, short p5, Short p6, int p7, Integer p8, long p9, Long p10, @P(value="biggy") BigInteger p11, float p12, Float p13, double p14, Double p15, @P(value="bigger") BigDecimal p16, String[] p17, Integer[] p18, Boolean[] p19, int[] p20, boolean[] p21, List<Integer> p22, Set<BigDecimal> p23, Collection<String> p24, E p25, Person p26, @P(value="optional", required=false) int p27, @P(value="required") int p28) {
            return 42;
        }

        @Tool(name="func_name")
        public int g(@ToolMemoryId String memoryId) {
            return 42;
        }

        public int unused(int i) {
            return 42;
        }
    }

    public static enum E {
        A,
        B,
        C;

    }

    public record Person(@Description(value={"Name of the person"}) String name, List<String> aliases, boolean active, Person parent, Address currentAddress, List<Address> previousAddresses) {
    }

    public static class CustomerRegistration {
        @Tool(value={"register a new customer"})
        boolean registerCustomer(Customer customer) {
            return true;
        }
    }

    public static class InvalidToolsWithDuplicateNames {
        @Tool(name="duplicate_name")
        public int oneMethod(String typeString) {
            return 42;
        }

        @Tool(name="duplicate_name")
        public int aDifferentMethod(int typeInt) {
            return 42;
        }
    }

    public static class InvalidToolsWithDuplicateMethodNames {
        @Tool
        public int duplicateMethod(String typeString) {
            return 42;
        }

        @Tool
        public int duplicateMethod(int typeInt) {
            return 42;
        }
    }

    record Customer(String name, Address billingAddress, Address shippingAddress) {
    }

    public static class Address {
        private String street;
        private String city;
    }
}

