/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import assertk.Assert;
import assertk.AssertKt;
import assertk.assertions.AnyKt;
import assertk.assertions.StringKt;
import dev.langchain4j.data.document.Metadata;
import java.util.Map;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@kotlin.Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007J\b\u0010\u0007\u001a\u00020\u0004H\u0007\u00a8\u0006\b"}, d2={"Ldev/langchain4j/data/document/MergeMetadataTest;", "", "()V", "merge should combine unique metadata from both objects", "", "merge should combine with empty metadata", "merge should combine with null object", "merge should throw an exception when there are common keys", "langchain4j-core"})
@SourceDebugExtension(value={"SMAP\nMergeMetadataTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeMetadataTest.kt\ndev/langchain4j/data/document/MergeMetadataTest\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,90:1\n108#2,4:91\n107#2,8:95\n*S KotlinDebug\n*F\n+ 1 MergeMetadataTest.kt\ndev/langchain4j/data/document/MergeMetadataTest\n*L\n82#1:91,4\n82#1:95,8\n*E\n"})
public final class MergeMetadataTest {
    @Test
    public final void merge should combine unique metadata from both objects() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        Metadata metadata1 = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"key3", (Object)"value3"), TuplesKt.to((Object)"key4", (Object)"value4")};
        Metadata metadata2 = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray2));
        Metadata result2 = metadata1.merge(metadata2);
        Pair[] pairArray3 = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2"), TuplesKt.to((Object)"key3", (Object)"value3"), TuplesKt.to((Object)"key4", (Object)"value4")};
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)result2.toMap(), null, null, (int)6, null), (Object)MapsKt.mapOf((Pair[])pairArray3));
    }

    @Test
    public final void merge should combine with null object() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        Metadata metadata = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray));
        Metadata result2 = metadata.merge(null);
        AnyKt.isNotSameInstanceAs((Assert)AssertKt.assertThat$default((Object)result2, null, null, (int)6, null), (Object)metadata);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)result2.toMap(), null, null, (int)6, null), (Object)MapsKt.mapOf((Pair[])pairArray2));
    }

    @Test
    public final void merge should combine with empty metadata() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        Metadata metadata = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray));
        Metadata result2 = metadata.merge(new Metadata());
        AnyKt.isNotSameInstanceAs((Assert)AssertKt.assertThat$default((Object)result2, null, null, (int)6, null), (Object)metadata);
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)result2.toMap(), null, null, (int)6, null), (Object)MapsKt.mapOf((Pair[])pairArray2));
    }

    @Test
    public final void merge should throw an exception when there are common keys() {
        Throwable throwable;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"key1", (Object)"value1"), TuplesKt.to((Object)"key2", (Object)"value2")};
        Metadata metadata1 = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"key2", (Object)"value3"), TuplesKt.to((Object)"key3", (Object)"value4")};
        Metadata metadata2 = Metadata.from((Map)MapsKt.mapOf((Pair[])pairArray2));
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            metadata1.merge(metadata2);
            throwable = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable = caught$iv;
        }
        Throwable throwable2 = throwable;
        Throwable throwable$iv = throwable2 instanceof Throwable ? throwable2 : null;
        Throwable throwable3 = Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = $throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)throwable3, (String)"throwable: Throwable? =\n\u2026throwable\n        }\n    }");
        IllegalArgumentException exception = (IllegalArgumentException)throwable3;
        StringKt.isEqualTo$default((Assert)AssertKt.assertThat$default((Object)exception.getMessage(), null, null, (int)6, null), (String)"Metadata keys are not unique. Common keys: [key2]", (boolean)false, (int)2, null);
    }
}

