/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.CustomMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class CustomMessageTest
implements WithAssertions {
    CustomMessageTest() {
    }

    @Test
    void methods() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("content", "The sky is blue.");
        attributes.put("myAttribute", "myValue");
        CustomMessage message = new CustomMessage(attributes);
        this.assertThat(message.attributes()).isEqualTo(attributes);
        this.assertThat((Comparable)message.type()).isEqualTo((Object)ChatMessageType.CUSTOM);
        this.assertThat(message).hasToString("CustomMessage { attributes = {content=The sky is blue., myAttribute=myValue} }");
    }

    @Test
    void equals_hash_code() {
        Map<String, String> attributes = Map.of("content", "The sky is blue.", "myAttribute", "myValue");
        Map<String, String> changedAttributes = Map.of("content", "The sky is blue.", "myAttribute", "foo");
        CustomMessage c1 = new CustomMessage(attributes);
        CustomMessage c2 = new CustomMessage(attributes);
        CustomMessage c3 = new CustomMessage(changedAttributes);
        CustomMessage c4 = new CustomMessage(changedAttributes);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(c1).isEqualTo((Object)c1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)c2)).hasSameHashCodeAs((Object)c2)).isNotEqualTo((Object)CustomMessage.from(changedAttributes))).isNotEqualTo((Object)c3)).doesNotHaveSameHashCodeAs((Object)c3);
        ((ObjectAssert)((ObjectAssert)this.assertThat(c3).isEqualTo((Object)c3)).isEqualTo((Object)c4)).hasSameHashCodeAs((Object)c4);
    }

    @Test
    void builders() {
        Map<String, String> attributes = Map.of("text", "The sky is blue.", "myAttribute", "myValue");
        ((ObjectAssert)this.assertThat(new CustomMessage(attributes)).isEqualTo((Object)CustomMessage.from(attributes))).isEqualTo((Object)CustomMessage.customMessage(attributes));
    }
}

