/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class StreamingChatLanguageModelTest
implements WithAssertions {
    StreamingChatLanguageModelTest() {
    }

    @Test
    void generate() {
        StreamingUpperCaseEchoModel model = new StreamingUpperCaseEchoModel();
        ArrayList<Object> messages = new ArrayList<Object>();
        messages.add(new UserMessage("Hello"));
        messages.add(new AiMessage("Hi"));
        messages.add(new UserMessage("How are you?"));
        CollectorResponseHandler handler = new CollectorResponseHandler();
        model.chat(messages, handler);
        ChatResponse response2 = handler.responses().get(0);
        this.assertThat(response2.aiMessage().text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response2.tokenUsage()).isNull();
        this.assertThat((Comparable)response2.finishReason()).isNull();
        CollectorResponseHandler handler2 = new CollectorResponseHandler();
        model.chat("How are you?", handler2);
        ChatResponse response3 = handler2.responses().get(0);
        this.assertThat(response3.aiMessage().text()).isEqualTo("HOW ARE YOU?");
        this.assertThat(response3.tokenUsage()).isNull();
        this.assertThat((Comparable)response3.finishReason()).isNull();
    }

    public static class StreamingUpperCaseEchoModel
    implements StreamingChatLanguageModel {
        public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
            List messages = chatRequest.messages();
            UserMessage lastMessage = (UserMessage)messages.get(messages.size() - 1);
            ChatResponse chatResponse = ChatResponse.builder().aiMessage(new AiMessage(lastMessage.singleText().toUpperCase(Locale.ROOT))).build();
            handler.onCompleteResponse(chatResponse);
        }
    }

    public static final class CollectorResponseHandler
    implements StreamingChatResponseHandler {
        private final List<ChatResponse> responses = new ArrayList<ChatResponse>();

        public List<ChatResponse> responses() {
            return this.responses;
        }

        public void onPartialResponse(String partialResponse) {
        }

        public void onCompleteResponse(ChatResponse completeResponse) {
            this.responses.add(completeResponse);
        }

        public void onError(Throwable error) {
        }
    }
}

