/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.TestStreamingChatResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelErrorContext;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.listener.ChatModelRequestContext;
import dev.langchain4j.model.chat.listener.ChatModelResponseContext;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

public abstract class StreamingChatModelListenerIT {
    protected abstract StreamingChatLanguageModel createModel(ChatModelListener var1);

    protected abstract String modelName();

    protected Double temperature() {
        return 0.7;
    }

    protected Double topP() {
        return 1.0;
    }

    protected Integer maxTokens() {
        return 7;
    }

    protected abstract StreamingChatLanguageModel createFailingModel(ChatModelListener var1);

    protected abstract Class<? extends Exception> expectedExceptionClass();

    @Test
    void should_listen_request_and_response() {
        final AtomicReference chatRequestReference = new AtomicReference();
        final AtomicInteger onRequestInvocations = new AtomicInteger();
        final AtomicReference chatResponseReference = new AtomicReference();
        final AtomicInteger onResponseInvocations = new AtomicInteger();
        final AtomicReference<StreamingChatLanguageModel> modelReference = new AtomicReference<StreamingChatLanguageModel>();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                chatRequestReference.set(requestContext.chatRequest());
                onRequestInvocations.incrementAndGet();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)requestContext.modelProvider()).isNotNull()).isEqualTo((Object)((StreamingChatLanguageModel)modelReference.get()).provider());
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                chatResponseReference.set(responseContext.chatResponse());
                onResponseInvocations.incrementAndGet();
                Assertions.assertThat((Object)responseContext.chatRequest()).isEqualTo(chatRequestReference.get());
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)responseContext.modelProvider()).isNotNull()).isEqualTo((Object)((StreamingChatLanguageModel)modelReference.get()).provider());
                Assertions.assertThat((Map)responseContext.attributes()).containsEntry((Object)"id", (Object)"12345");
            }

            public void onError(ChatModelErrorContext errorContext) {
                Assertions.fail((String)("onError() must not be called. Exception: " + errorContext.error().getMessage()));
            }
        };
        StreamingChatLanguageModel model = this.createModel(listener);
        modelReference.set(model);
        UserMessage userMessage = UserMessage.from((String)"hello");
        ChatRequest.Builder chatRequestBuilder = ChatRequest.builder().messages(new ChatMessage[]{userMessage});
        ToolSpecification toolSpecification = null;
        if (this.supportsTools()) {
            toolSpecification = ToolSpecification.builder().name("add").parameters(JsonObjectSchema.builder().addIntegerProperty("a").addIntegerProperty("b").build()).build();
            chatRequestBuilder.toolSpecifications(new ToolSpecification[]{toolSpecification});
        }
        ChatRequest chatRequest = chatRequestBuilder.build();
        TestStreamingChatResponseHandler handler = new TestStreamingChatResponseHandler();
        model.chat(chatRequest, (StreamingChatResponseHandler)handler);
        AiMessage aiMessage = handler.get().aiMessage();
        ChatRequest observedChatRequest = (ChatRequest)chatRequestReference.get();
        Assertions.assertThat((List)observedChatRequest.messages()).containsExactly((Object[])new ChatMessage[]{userMessage});
        ChatRequestParameters parameters = observedChatRequest.parameters();
        Assertions.assertThat((String)parameters.modelName()).isEqualTo(this.modelName());
        Assertions.assertThat((Double)parameters.temperature()).isCloseTo(this.temperature(), Percentage.withPercentage((double)1.0));
        Assertions.assertThat((Double)parameters.topP()).isEqualTo(this.topP());
        Assertions.assertThat((Integer)parameters.maxOutputTokens()).isEqualTo((Object)this.maxTokens());
        if (this.supportsTools()) {
            Assertions.assertThat((List)parameters.toolSpecifications()).containsExactly((Object[])new ToolSpecification[]{toolSpecification});
        }
        Assertions.assertThat((AtomicInteger)onRequestInvocations).hasValue(1);
        ChatResponse chatResponse = (ChatResponse)chatResponseReference.get();
        Assertions.assertThat((Object)chatResponse.aiMessage()).isEqualTo((Object)aiMessage);
        ChatResponseMetadata metadata = chatResponse.metadata();
        if (this.assertResponseId()) {
            Assertions.assertThat((String)metadata.id()).isNotBlank();
        }
        if (this.assertResponseModel()) {
            Assertions.assertThat((String)metadata.modelName()).isNotBlank();
        }
        if (this.assertTokenUsage()) {
            Assertions.assertThat((Integer)metadata.tokenUsage().inputTokenCount()).isGreaterThan(0);
            Assertions.assertThat((Integer)metadata.tokenUsage().outputTokenCount()).isGreaterThan(0);
            Assertions.assertThat((Integer)metadata.tokenUsage().totalTokenCount()).isGreaterThan(0);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)metadata.finishReason()).isNotNull();
        }
        Assertions.assertThat((AtomicInteger)onResponseInvocations).hasValue(1);
    }

    protected boolean supportsTools() {
        return true;
    }

    protected boolean assertResponseId() {
        return true;
    }

    protected boolean assertResponseModel() {
        return true;
    }

    protected boolean assertTokenUsage() {
        return true;
    }

    protected boolean assertFinishReason() {
        return true;
    }

    @Test
    protected void should_listen_error() throws Exception {
        final AtomicReference chatRequestReference = new AtomicReference();
        final AtomicInteger onRequestInvocations = new AtomicInteger();
        final AtomicReference errorReference = new AtomicReference();
        final AtomicInteger onErrorInvocations = new AtomicInteger();
        final AtomicReference<StreamingChatLanguageModel> modelReference = new AtomicReference<StreamingChatLanguageModel>();
        ChatModelListener listener = new ChatModelListener(){

            public void onRequest(ChatModelRequestContext requestContext) {
                chatRequestReference.set(requestContext.chatRequest());
                onRequestInvocations.incrementAndGet();
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)requestContext.modelProvider()).isNotNull()).isEqualTo((Object)((StreamingChatLanguageModel)modelReference.get()).provider());
                requestContext.attributes().put("id", "12345");
            }

            public void onResponse(ChatModelResponseContext responseContext) {
                Assertions.fail((String)"onResponse() must not be called");
            }

            public void onError(ChatModelErrorContext errorContext) {
                errorReference.set(errorContext.error());
                onErrorInvocations.incrementAndGet();
                Assertions.assertThat((Object)errorContext.chatRequest()).isEqualTo(chatRequestReference.get());
                ((AbstractComparableAssert)Assertions.assertThat((Comparable)errorContext.modelProvider()).isNotNull()).isEqualTo((Object)((StreamingChatLanguageModel)modelReference.get()).provider());
                Assertions.assertThat((Map)errorContext.attributes()).containsEntry((Object)"id", (Object)"12345");
            }
        };
        StreamingChatLanguageModel model = this.createFailingModel(listener);
        modelReference.set(model);
        String userMessage = "this message will fail";
        final CompletableFuture future = new CompletableFuture();
        StreamingChatResponseHandler handler = new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                Assertions.fail((String)"onPartialResponse() must not be called");
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                Assertions.fail((String)"onCompleteResponse() must not be called");
            }

            public void onError(Throwable error) {
                future.complete(error);
            }
        };
        model.chat(userMessage, handler);
        Throwable throwable = (Throwable)future.get(5L, TimeUnit.SECONDS);
        Assertions.assertThat((Throwable)throwable).isExactlyInstanceOf(this.expectedExceptionClass());
        Assertions.assertThat((Throwable)((Throwable)errorReference.get())).isSameAs((Object)throwable);
        Assertions.assertThat((AtomicInteger)onRequestInvocations).hasValue(1);
        Assertions.assertThat((AtomicInteger)onErrorInvocations).hasValue(1);
    }
}

