/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.output.Response;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;

public class TestStreamingResponseHandler<T>
implements StreamingResponseHandler<T> {
    private final CompletableFuture<Response<T>> futureResponse = new CompletableFuture();
    private final StringBuffer textContentBuilder = new StringBuffer();

    public void onNext(String token) {
        this.textContentBuilder.append(token);
    }

    public void onComplete(Response<T> response2) {
        String expectedTextContent = this.textContentBuilder.toString();
        Object object = response2.content();
        if (object instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)object;
            if (aiMessage.hasToolExecutionRequests()) {
                Assertions.assertThat((int)aiMessage.toolExecutionRequests().size()).isGreaterThan(0);
            } else {
                Assertions.assertThat((String)aiMessage.text()).isEqualTo(expectedTextContent);
            }
        } else if (response2.content() instanceof String) {
            Assertions.assertThat((Object)response2.content()).isEqualTo((Object)expectedTextContent);
        } else {
            throw Exceptions.illegalArgument((String)("Unknown response content: " + String.valueOf(response2.content())), (Object[])new Object[0]);
        }
        this.futureResponse.complete(response2);
    }

    public void onError(Throwable error) {
        this.futureResponse.completeExceptionally(error);
    }

    public Response<T> get() {
        try {
            return this.futureResponse.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }
}

