/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.mock;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StreamingChatModelMock
implements StreamingChatLanguageModel {
    private final List<String> tokens;

    public StreamingChatModelMock(List<String> tokens) {
        this.tokens = new ArrayList<String>(ValidationUtils.ensureNotEmpty(tokens, (String)"tokens"));
    }

    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        this.tokens.forEach(arg_0 -> ((StreamingChatResponseHandler)handler).onPartialResponse(arg_0));
        AiMessage aiMessage = AiMessage.from((String)String.join((CharSequence)"", this.tokens));
        ChatResponse chatResponse = ChatResponse.builder().aiMessage(aiMessage).build();
        handler.onCompleteResponse(chatResponse);
    }

    public static StreamingChatModelMock thatAlwaysStreams(String ... tokens) {
        return new StreamingChatModelMock(Arrays.asList(tokens));
    }

    public static StreamingChatModelMock thatAlwaysStreams(List<String> tokens) {
        return new StreamingChatModelMock(tokens);
    }
}

