/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import assertk.Assert;
import assertk.AssertKt;
import assertk.assertions.AnyKt;
import assertk.assertions.ComparableKt;
import assertk.assertions.ListKt;
import assertk.assertions.StringKt;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestBuilder;
import dev.langchain4j.model.chat.request.ChatRequestExtensionsKt;
import dev.langchain4j.model.chat.request.ChatRequestExtensionsTest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ChatRequestParametersBuilder;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.TestChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.ContainExactlyKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007J\b\u0010\u0006\u001a\u00020\u0004H\u0007\u00a8\u0006\u0007"}, d2={"Ldev/langchain4j/model/chat/request/ChatRequestExtensionsTest;", "", "()V", "Should build ChatRequest", "", "Should build ChatRequest with OpenAi parameters builder", "Should build ChatRequest with parameters builder", "langchain4j-core"})
public final class ChatRequestExtensionsTest {
    @Test
    public final void Should build ChatRequest() {
        SystemMessage systemMessage = SystemMessage.systemMessage((String)"You are a helpful assistant");
        UserMessage userMessage = UserMessage.userMessage((String)"Send greeting");
        Object object = Mockito.mock((Object[])new ChatRequestParameters[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mock(...)");
        ChatRequestParameters params = (ChatRequestParameters)object;
        ChatRequest result2 = ChatRequestExtensionsKt.chatRequest((Function1)((Function1)new Function1<ChatRequestBuilder, Unit>(systemMessage, userMessage, params){
            final /* synthetic */ SystemMessage $systemMessage;
            final /* synthetic */ UserMessage $userMessage;
            final /* synthetic */ ChatRequestParameters $params;
            {
                this.$systemMessage = $systemMessage;
                this.$userMessage = $userMessage;
                this.$params = $params;
                super(1);
            }

            public final void invoke(@NotNull ChatRequestBuilder $this$chatRequest) {
                Intrinsics.checkNotNullParameter((Object)$this$chatRequest, (String)"$this$chatRequest");
                ((Collection)$this$chatRequest.getMessages()).add(this.$systemMessage);
                ((Collection)$this$chatRequest.getMessages()).add(this.$userMessage);
                ChatRequestBuilder.parameters$default((ChatRequestBuilder)$this$chatRequest, null, (Function1)Should build ChatRequest.result.1.INSTANCE, (int)1, null);
                $this$chatRequest.setParameters(this.$params);
            }
        }));
        Object[] objectArray = new ChatMessage[]{systemMessage, userMessage};
        ContainExactlyKt.shouldContainExactly((Collection)result2.messages(), (Collection)CollectionsKt.listOf((Object[])objectArray));
        ShouldKt.shouldBe((Object)result2.parameters(), (Object)params);
        ShouldKt.shouldNotBe((Object)result2.parameters().temperature(), (Object)0.1);
    }

    @Test
    public final void Should build ChatRequest with parameters builder() {
        SystemMessage systemMessage = SystemMessage.systemMessage((String)"You are a helpful assistant");
        UserMessage userMessage = UserMessage.userMessage((String)"Send greeting");
        Object object = Mockito.mock((Object[])new ToolSpecification[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mock(...)");
        ToolSpecification toolSpec = (ToolSpecification)object;
        List toolSpecs = CollectionsKt.listOf((Object)toolSpec);
        ChatRequest result2 = ChatRequestExtensionsKt.chatRequest((Function1)((Function1)new Function1<ChatRequestBuilder, Unit>(systemMessage, userMessage, (List<? extends ToolSpecification>)toolSpecs){
            final /* synthetic */ SystemMessage $systemMessage;
            final /* synthetic */ UserMessage $userMessage;
            final /* synthetic */ List<ToolSpecification> $toolSpecs;
            {
                this.$systemMessage = $systemMessage;
                this.$userMessage = $userMessage;
                this.$toolSpecs = $toolSpecs;
                super(1);
            }

            public final void invoke(@NotNull ChatRequestBuilder $this$chatRequest) {
                Intrinsics.checkNotNullParameter((Object)$this$chatRequest, (String)"$this$chatRequest");
                ((Collection)$this$chatRequest.getMessages()).add(this.$systemMessage);
                ((Collection)$this$chatRequest.getMessages()).add(this.$userMessage);
                ChatRequestBuilder.parameters$default((ChatRequestBuilder)$this$chatRequest, null, (Function1)((Function1)new Function1<ChatRequestParametersBuilder<DefaultChatRequestParameters.Builder<?>>, Unit>(this.$toolSpecs){
                    final /* synthetic */ List<ToolSpecification> $toolSpecs;
                    {
                        this.$toolSpecs = $toolSpecs;
                        super(1);
                    }

                    public final void invoke(@NotNull ChatRequestParametersBuilder<DefaultChatRequestParameters.Builder<?>> $this$parameters) {
                        Intrinsics.checkNotNullParameter($this$parameters, (String)"$this$parameters");
                        $this$parameters.setTemperature(Double.valueOf(0.1));
                        $this$parameters.setModelName("super-model");
                        $this$parameters.setTopP(Double.valueOf(0.2));
                        $this$parameters.setTopK(Integer.valueOf(3));
                        $this$parameters.setFrequencyPenalty(Double.valueOf(0.4));
                        $this$parameters.setPresencePenalty(Double.valueOf(0.5));
                        $this$parameters.setMaxOutputTokens(Integer.valueOf(6));
                        Object[] objectArray = new String[]{"halt", "stop"};
                        $this$parameters.setStopSequences(CollectionsKt.listOf((Object[])objectArray));
                        $this$parameters.setToolSpecifications(this.$toolSpecs);
                        $this$parameters.setToolChoice(ToolChoice.REQUIRED);
                        $this$parameters.setResponseFormat(ResponseFormat.JSON);
                    }
                }), (int)1, null);
            }
        }));
        ChatRequestParameters parameters = result2.parameters();
        AnyKt.isInstanceOf((Assert)AssertKt.assertThat$default((Object)parameters, null, null, (int)6, null), (KClass)Reflection.getOrCreateKotlinClass(DefaultChatRequestParameters.class));
        ComparableKt.isCloseTo((Assert)AssertKt.assertThat$default((Object)parameters.temperature(), null, null, (int)6, null), (double)0.1, (double)1.0E-6);
        StringKt.isEqualTo$default((Assert)AssertKt.assertThat$default((Object)parameters.modelName(), null, null, (int)6, null), (String)"super-model", (boolean)false, (int)2, null);
        ComparableKt.isCloseTo((Assert)AssertKt.assertThat$default((Object)parameters.topP(), null, null, (int)6, null), (double)0.2, (double)1.0E-6);
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)parameters.topK(), null, null, (int)6, null), (Object)3);
        ComparableKt.isCloseTo((Assert)AssertKt.assertThat$default((Object)parameters.frequencyPenalty(), null, null, (int)6, null), (double)0.4, (double)1.0E-6);
        ComparableKt.isCloseTo((Assert)AssertKt.assertThat$default((Object)parameters.presencePenalty(), null, null, (int)6, null), (double)0.5, (double)1.0E-6);
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)parameters.maxOutputTokens(), null, null, (int)6, null), (Object)6);
        Object[] objectArray = new Object[]{"halt", "stop"};
        ListKt.containsExactly((Assert)AssertKt.assertThat$default((Object)parameters.stopSequences(), null, null, (int)6, null), (Object[])objectArray);
        objectArray = new Object[]{toolSpec};
        ListKt.containsExactly((Assert)AssertKt.assertThat$default((Object)parameters.toolSpecifications(), null, null, (int)6, null), (Object[])objectArray);
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)parameters.toolChoice(), null, null, (int)6, null), (Object)ToolChoice.REQUIRED);
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)parameters.responseFormat(), null, null, (int)6, null), (Object)ResponseFormat.JSON);
    }

    @Test
    public final void Should build ChatRequest with OpenAi parameters builder() {
        SystemMessage systemMessage = SystemMessage.systemMessage((String)"You are a helpful assistant");
        UserMessage userMessage = UserMessage.userMessage((String)"Send greeting");
        ChatRequest result2 = ChatRequestExtensionsKt.chatRequest((Function1)((Function1)new Function1<ChatRequestBuilder, Unit>(systemMessage, userMessage){
            final /* synthetic */ SystemMessage $systemMessage;
            final /* synthetic */ UserMessage $userMessage;
            {
                this.$systemMessage = $systemMessage;
                this.$userMessage = $userMessage;
                super(1);
            }

            public final void invoke(@NotNull ChatRequestBuilder $this$chatRequest) {
                Intrinsics.checkNotNullParameter((Object)$this$chatRequest, (String)"$this$chatRequest");
                ((Collection)$this$chatRequest.getMessages()).add(this.$systemMessage);
                ((Collection)$this$chatRequest.getMessages()).add(this.$userMessage);
                $this$chatRequest.parameters((DefaultChatRequestParameters.Builder)TestChatRequestParameters.Companion.builder(), (Function1)Should build ChatRequest with OpenAi parameters builder.result.1.INSTANCE);
            }
        }));
        ChatRequestParameters chatRequestParameters = result2.parameters();
        Intrinsics.checkNotNull((Object)chatRequestParameters, (String)"null cannot be cast to non-null type dev.langchain4j.model.chat.request.TestChatRequestParameters");
        TestChatRequestParameters parameters = (TestChatRequestParameters)chatRequestParameters;
        ComparableKt.isCloseTo((Assert)AssertKt.assertThat$default((Object)parameters.temperature(), null, null, (int)6, null), (double)0.1, (double)1.0E-6);
        AnyKt.isEqualTo((Assert)AssertKt.assertThat$default((Object)parameters.getSeed(), null, null, (int)6, null), (Object)42);
    }
}

