/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ToolChoice;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultChatRequestParametersTest {
    DefaultChatRequestParametersTest() {
    }

    @Test
    void override_with() {
        ChatRequestParameters original = DefaultChatRequestParameters.builder().modelName("model-1").temperature(Double.valueOf(0.7)).topP(Double.valueOf(0.8)).topK(Integer.valueOf(10)).frequencyPenalty(Double.valueOf(0.5)).presencePenalty(Double.valueOf(0.3)).maxOutputTokens(Integer.valueOf(100)).stopSequences(new String[]{"stop1", "stop2"}).toolSpecifications(List.of(ToolSpecification.builder().name("tool1").build(), ToolSpecification.builder().name("tool2").build())).toolChoice(ToolChoice.AUTO).build();
        ChatRequestParameters override = DefaultChatRequestParameters.builder().modelName("model-2").temperature(Double.valueOf(0.9)).build();
        ChatRequestParameters result2 = original.overrideWith(override);
        Assertions.assertThat((String)result2.modelName()).isEqualTo("model-2");
        Assertions.assertThat((Double)result2.temperature()).isEqualTo(0.9);
        Assertions.assertThat((Double)result2.topP()).isEqualTo(0.8);
        Assertions.assertThat((Integer)result2.topK()).isEqualTo(10);
        Assertions.assertThat((Double)result2.frequencyPenalty()).isEqualTo(0.5);
        Assertions.assertThat((Double)result2.presencePenalty()).isEqualTo(0.3);
        Assertions.assertThat((Integer)result2.maxOutputTokens()).isEqualTo(100);
        Assertions.assertThat((List)result2.stopSequences()).containsExactly((Object[])new String[]{"stop1", "stop2"});
        Assertions.assertThat((List)result2.toolSpecifications()).hasSize(2);
        Assertions.assertThat((Comparable)result2.toolChoice()).isEqualTo((Object)ToolChoice.AUTO);
    }
}

