/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.image;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.model.image.ImageModel;
import dev.langchain4j.model.output.Response;
import java.net.URI;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ImageModelTest
implements WithAssertions {
    public static final Image PLACEHOLDER_IMAGE;

    ImageModelTest() {
    }

    @Test
    void not_supported() {
        FixedImageModel model = new FixedImageModel(PLACEHOLDER_IMAGE);
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> model.generate("prompt", 1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Operation is not supported");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> model.edit(null, "prompt")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Operation is not supported");
        ((AbstractThrowableAssert)this.assertThatThrownBy(() -> model.edit(null, null, "prompt")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Operation is not supported");
    }

    @Test
    void trivial() {
        FixedImageModel model = new FixedImageModel(PLACEHOLDER_IMAGE);
        Response response2 = model.generate("prompt");
        this.assertThat(response2).isNotNull();
        this.assertThat((Image)response2.content()).isEqualTo((Object)PLACEHOLDER_IMAGE);
    }

    static {
        try {
            PLACEHOLDER_IMAGE = Image.builder().url(new URI("https://foo.bar")).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class FixedImageModel
    implements ImageModel {
        private final Image image;

        public FixedImageModel(Image image) {
            this.image = image;
        }

        public Response<Image> generate(String prompt) {
            return Response.from((Object)this.image);
        }
    }
}

