/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class PromptTemplateTest {
    PromptTemplateTest() {
    }

    @Test
    void should_create_prompt_from_template_without_variables() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Hello world.");
        Map variables = Collections.emptyMap();
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("Hello world.");
    }

    @Test
    void should_create_prompt_from_template_with_it_variable() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{it}}.");
        Prompt prompt = promptTemplate.apply((Object)"Klaus");
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus.");
    }

    @Test
    void should_create_prompt_from_template_with_single_variable() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{name}}.");
        Map<String, String> variables = Collections.singletonMap("name", "Klaus");
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus.");
    }

    @Test
    void should_create_prompt_from_template_with_multiple_variables() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{name}}, I am {{age}} years old.");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("name", "Klaus");
        variables.put("age", 42);
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus, I am 42 years old.");
    }

    @Test
    void should_allow_same_variable_in_template_multiple_times() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{name}}, call me {{name}}.");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("name", "Klaus");
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus, call me Klaus.");
    }

    @Test
    void should_fail_when_value_is_missing() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{name}}.");
        Map variables = Collections.emptyMap();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> promptTemplate.apply(variables)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Value for the variable 'name' is missing");
    }

    @Test
    void should_fail_when_value_is_null() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"My name is {{name}}.");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("name", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> promptTemplate.apply(variables)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("Value for the variable 'name' is null");
    }

    @Test
    void should_provide_date_automatically() {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"Today is {{current_date}}");
        Map variables = Collections.emptyMap();
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("Today is " + String.valueOf(LocalDate.now()));
    }

    @Test
    void should_provide_time_automatically() {
        Clock clock = Clock.fixed(Instant.now(), ZoneOffset.UTC);
        PromptTemplate promptTemplate = new PromptTemplate("My name is {{it}} and now is {{current_time}}", clock);
        Prompt prompt = promptTemplate.apply((Object)"Klaus");
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus and now is " + String.valueOf(LocalTime.now(clock)));
    }

    @Test
    void should_provide_date_and_time_automatically() {
        Clock clock = Clock.fixed(Instant.now(), ZoneOffset.UTC);
        PromptTemplate promptTemplate = new PromptTemplate("My name is {{name}} and now is {{current_date_time}}", clock);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("name", "Klaus");
        Prompt prompt = promptTemplate.apply(variables);
        Assertions.assertThat((String)prompt.text()).isEqualTo("My name is Klaus and now is " + String.valueOf(LocalDateTime.now(clock)));
    }

    @ParameterizedTest
    @ValueSource(strings={"$", "$$", "{", "{{", "}", "}}", "{}", "{{}}", "*", "**", "\\", "\\\\", "${}*\\", "${ *hello* }", "\\$\\{ \\*hello\\* \\}"})
    void should_support_special_characters(String s) {
        PromptTemplate promptTemplate = PromptTemplate.from((String)"This is {{it}}.");
        Prompt prompt = promptTemplate.apply((Object)s);
        Assertions.assertThat((String)prompt.text()).isEqualTo("This is " + s + ".");
    }
}

