/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.scoring;

import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.scoring.ScoringModel;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ScoringModelTest {
    private static final double SCORE = 0.7;

    ScoringModelTest() {
    }

    @Test
    void should_score_text() {
        String text = "text";
        TestScoringModel model = new TestScoringModel();
        Response response2 = model.score(text, "query");
        Assertions.assertThat((Double)((Double)response2.content())).isEqualTo(0.7);
    }

    @Test
    void should_score_text_segment() {
        TextSegment segment = TextSegment.from((String)"text");
        TestScoringModel model = new TestScoringModel();
        Response response2 = model.score(segment, "query");
        Assertions.assertThat((Double)((Double)response2.content())).isEqualTo(0.7);
    }

    static class TestScoringModel
    implements ScoringModel {
        TestScoringModel() {
        }

        public Response<List<Double>> scoreAll(List<TextSegment> segments, String query) {
            return Response.from(Collections.singletonList(0.7));
        }
    }
}

