/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.rag.query.Metadata;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class MetadataTest {
    MetadataTest() {
    }

    @Test
    void create() {
        UserMessage userMessage = UserMessage.from((String)"user message");
        int chatMemoryId = 42;
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?"));
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)chatMemoryId, chatMemory);
        Assertions.assertThat((Object)metadata.chatMessage()).isSameAs((Object)userMessage);
        Assertions.assertThat((Object)metadata.chatMemoryId()).isSameAs((Object)chatMemoryId);
        Assertions.assertThat((List)metadata.chatMemory()).isNotSameAs(chatMemory).isEqualTo(chatMemory);
    }

    @Test
    void equals_hash_code() {
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"another user message"), (Object)666, Arrays.asList(UserMessage.from((String)"Bye"), AiMessage.from((String)"Bye-bye")));
        Metadata metadata3 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isNotEqualTo((Object)metadata2)).doesNotHaveSameHashCodeAs((Object)metadata2);
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isEqualTo((Object)metadata3)).hasSameHashCodeAs((Object)metadata3);
    }

    @Test
    void to_string() {
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        String toString = metadata.toString();
        Assertions.assertThat((String)toString).isEqualTo("Metadata { chatMessage = UserMessage { name = null contents = [TextContent { text = \"user message\" }] }, chatMemoryId = 42, chatMemory = [UserMessage { name = null contents = [TextContent { text = \"Hello\" }] }, AiMessage { text = \"Hi, how can I help you today?\" toolExecutionRequests = null }] }");
    }
}

