/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingStoreIT;
import dev.langchain4j.store.embedding.TestUtils;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.MetadataFilterBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class EmbeddingStoreWithFilteringIT
extends EmbeddingStoreIT {
    @ParameterizedTest
    @MethodSource
    protected void should_filter_by_metadata(Filter metadataFilter, List<Metadata> matchingMetadatas, List<Metadata> notMatchingMetadatas) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        for (Metadata matchingMetadata : matchingMetadatas) {
            TextSegment matchingSegment = TextSegment.from((String)"matching", (Metadata)matchingMetadata);
            Embedding matchingEmbedding = (Embedding)this.embeddingModel().embed(matchingSegment).content();
            embeddings.add(matchingEmbedding);
            segments.add(matchingSegment);
        }
        for (Metadata notMatchingMetadata : notMatchingMetadatas) {
            TextSegment notMatchingSegment = TextSegment.from((String)"not matching", (Metadata)notMatchingMetadata);
            Embedding notMatchingEmbedding = (Embedding)this.embeddingModel().embed(notMatchingSegment).content();
            embeddings.add(notMatchingEmbedding);
            segments.add(notMatchingSegment);
        }
        this.embeddingStore().addAll(embeddings, segments);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(embeddings.size()));
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding((Embedding)this.embeddingModel().embed("matching").content()).filter(metadataFilter).maxResults(Integer.valueOf(100)).build();
        List matches = this.embeddingStore().search(embeddingSearchRequest).matches();
        Assertions.assertThat((List)matches).hasSize(matchingMetadatas.size());
        matches.forEach(match -> Assertions.assertThat((String)((TextSegment)match.embedded()).text()).isEqualTo("matching"));
        matches.forEach(match -> Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)0.01)));
    }

    protected static Stream<Arguments> should_filter_by_metadata() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo("a"), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key", "a").put("key2", "b")), Arrays.asList(new Metadata().put("key", "A"), new Metadata().put("key", "b"), new Metadata().put("key", "aa"), new Metadata().put("key", "a a"), new Metadata().put("key2", "a"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo(TEST_UUID), Arrays.asList(new Metadata().put("key", TEST_UUID), new Metadata().put("key", TEST_UUID).put("key2", UUID.randomUUID())), Arrays.asList(new Metadata().put("key", UUID.randomUUID()), new Metadata().put("key2", TEST_UUID), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo(1), Arrays.asList(new Metadata().put("key", 1), new Metadata().put("key", 1).put("key2", 0)), Arrays.asList(new Metadata().put("key", -1), new Metadata().put("key", 0), new Metadata().put("key2", 1), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo(1L), Arrays.asList(new Metadata().put("key", 1L), new Metadata().put("key", 1L).put("key2", 0L)), Arrays.asList(new Metadata().put("key", -1L), new Metadata().put("key", 0L), new Metadata().put("key2", 1L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo(1.23f), Arrays.asList(new Metadata().put("key", 1.23f), new Metadata().put("key", 1.23f).put("key2", 0.0f)), Arrays.asList(new Metadata().put("key", -1.23f), new Metadata().put("key", 1.22f), new Metadata().put("key", 1.24f), new Metadata().put("key2", 1.23f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isEqualTo(1.23), Arrays.asList(new Metadata().put("key", 1.23), new Metadata().put("key", 1.23).put("key2", 0.0)), Arrays.asList(new Metadata().put("key", -1.23), new Metadata().put("key", 1.22), new Metadata().put("key", 1.24), new Metadata().put("key2", 1.23), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan("b"), Arrays.asList(new Metadata().put("key", "c"), new Metadata().put("key", "c").put("key2", "a")), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key", "b"), new Metadata().put("key2", "c"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan(1), Arrays.asList(new Metadata().put("key", 2), new Metadata().put("key", 2).put("key2", 0)), Arrays.asList(new Metadata().put("key", -2), new Metadata().put("key", 0), new Metadata().put("key", 1), new Metadata().put("key2", 2), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan(2), Arrays.asList(new Metadata().put("key", 10)), Arrays.asList(new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan(1L), Arrays.asList(new Metadata().put("key", 2L), new Metadata().put("key", 2L).put("key2", 0L)), Arrays.asList(new Metadata().put("key", -2L), new Metadata().put("key", 0L), new Metadata().put("key", 1L), new Metadata().put("key2", 2L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan(1.1f), Arrays.asList(new Metadata().put("key", 1.2f), new Metadata().put("key", 1.2f).put("key2", 1.0f)), Arrays.asList(new Metadata().put("key", -1.2f), new Metadata().put("key", 0.0f), new Metadata().put("key", 1.1f), new Metadata().put("key2", 1.2f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThan(1.1), Arrays.asList(new Metadata().put("key", 1.2), new Metadata().put("key", 1.2).put("key2", 1.0)), Arrays.asList(new Metadata().put("key", -1.2), new Metadata().put("key", 0.0), new Metadata().put("key", 1.1), new Metadata().put("key2", 1.2), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThanOrEqualTo("b"), Arrays.asList(new Metadata().put("key", "b"), new Metadata().put("key", "c"), new Metadata().put("key", "c").put("key2", "a")), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key2", "b"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThanOrEqualTo(1), Arrays.asList(new Metadata().put("key", 1), new Metadata().put("key", 2), new Metadata().put("key", 2).put("key2", 0)), Arrays.asList(new Metadata().put("key", -2), new Metadata().put("key", -1), new Metadata().put("key", 0), new Metadata().put("key2", 1), new Metadata().put("key2", 2), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThanOrEqualTo(1L), Arrays.asList(new Metadata().put("key", 1L), new Metadata().put("key", 2L), new Metadata().put("key", 2L).put("key2", 0L)), Arrays.asList(new Metadata().put("key", -2L), new Metadata().put("key", -1L), new Metadata().put("key", 0L), new Metadata().put("key2", 1L), new Metadata().put("key2", 2L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThanOrEqualTo(1.1f), Arrays.asList(new Metadata().put("key", 1.1f), new Metadata().put("key", 1.2f), new Metadata().put("key", 1.2f).put("key2", 1.0f)), Arrays.asList(new Metadata().put("key", -1.2f), new Metadata().put("key", -1.1f), new Metadata().put("key", 0.0f), new Metadata().put("key2", 1.1f), new Metadata().put("key2", 1.2f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isGreaterThanOrEqualTo(1.1), Arrays.asList(new Metadata().put("key", 1.1), new Metadata().put("key", 1.2), new Metadata().put("key", 1.2).put("key2", 1.0)), Arrays.asList(new Metadata().put("key", -1.2), new Metadata().put("key", -1.1), new Metadata().put("key", 0.0), new Metadata().put("key2", 1.1), new Metadata().put("key2", 1.2), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThan("b"), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key", "a").put("key2", "c")), Arrays.asList(new Metadata().put("key", "b"), new Metadata().put("key", "c"), new Metadata().put("key2", "a"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThan(1), Arrays.asList(new Metadata().put("key", -2), new Metadata().put("key", 0), new Metadata().put("key", 0).put("key2", 2)), Arrays.asList(new Metadata().put("key", 1), new Metadata().put("key", 2), new Metadata().put("key2", 0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThan(1L), Arrays.asList(new Metadata().put("key", -2L), new Metadata().put("key", 0L), new Metadata().put("key", 0L).put("key2", 2L)), Arrays.asList(new Metadata().put("key", 1L), new Metadata().put("key", 2L), new Metadata().put("key2", 0L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThan(1.1f), Arrays.asList(new Metadata().put("key", -1.2f), new Metadata().put("key", 1.0f), new Metadata().put("key", 1.0f).put("key2", 1.2f)), Arrays.asList(new Metadata().put("key", 1.1f), new Metadata().put("key", 1.2f), new Metadata().put("key2", 1.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThan(1.1), Arrays.asList(new Metadata().put("key", -1.2), new Metadata().put("key", 1.0), new Metadata().put("key", 1.0).put("key2", 1.2)), Arrays.asList(new Metadata().put("key", 1.1), new Metadata().put("key", 1.2), new Metadata().put("key2", 1.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThanOrEqualTo("b"), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key", "b"), new Metadata().put("key", "b").put("key2", "c")), Arrays.asList(new Metadata().put("key", "c"), new Metadata().put("key2", "a"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThanOrEqualTo(1), Arrays.asList(new Metadata().put("key", -2), new Metadata().put("key", 0), new Metadata().put("key", 1), new Metadata().put("key", 1).put("key2", 2)), Arrays.asList(new Metadata().put("key", 2), new Metadata().put("key2", 0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThanOrEqualTo(1L), Arrays.asList(new Metadata().put("key", -2L), new Metadata().put("key", 0L), new Metadata().put("key", 1L), new Metadata().put("key", 1L).put("key2", 2L)), Arrays.asList(new Metadata().put("key", 2L), new Metadata().put("key2", 0L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThanOrEqualTo(1.1f), Arrays.asList(new Metadata().put("key", -1.2f), new Metadata().put("key", 1.0f), new Metadata().put("key", 1.1f), new Metadata().put("key", 1.1f).put("key2", 1.2f)), Arrays.asList(new Metadata().put("key", 1.2f), new Metadata().put("key2", 1.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isLessThanOrEqualTo(1.1), Arrays.asList(new Metadata().put("key", -1.2), new Metadata().put("key", 1.0), new Metadata().put("key", 1.1), new Metadata().put("key", 1.1).put("key2", 1.2)), Arrays.asList(new Metadata().put("key", 1.2), new Metadata().put("key2", 1.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(new String[]{"Klaus"}), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42)), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Alice"), new Metadata().put("name2", "Klaus"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(Collections.singletonList("Klaus")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42)), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Alice"), new Metadata().put("name2", "Klaus"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(new String[]{"Klaus", "Alice"}), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42)), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Zoe"), new Metadata().put("name2", "Klaus"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(Arrays.asList("Klaus", "Alice")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42)), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Zoe"), new Metadata().put("name2", "Klaus"), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(new UUID[]{TEST_UUID}), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(Collections.singletonList(TEST_UUID)), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(new UUID[]{TEST_UUID, TEST_UUID2}), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42), new Metadata().put("name", TEST_UUID2), new Metadata().put("name", TEST_UUID2).put("age", 42)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isIn(Arrays.asList(TEST_UUID, TEST_UUID2)), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42), new Metadata().put("name", TEST_UUID2), new Metadata().put("name", TEST_UUID2).put("age", 42)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new int[]{42}), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Collections.singletonList(42)), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new int[]{42, 18}), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 18), new Metadata().put("age", 42).put("name", "Klaus"), new Metadata().put("age", 18).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Arrays.asList(42, 18)), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 18), new Metadata().put("age", 42).put("name", "Klaus"), new Metadata().put("age", 18).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new long[]{42L}), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 42L).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Collections.singletonList(42L)), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 42L).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new long[]{42L, 18L}), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 18L), new Metadata().put("age", 42L).put("name", "Klaus"), new Metadata().put("age", 18L).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Arrays.asList(42L, 18L)), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 18L), new Metadata().put("age", 42L).put("name", "Klaus"), new Metadata().put("age", 18L).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new float[]{42.0f}), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 42.0f).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Collections.singletonList(Float.valueOf(42.0f))), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 42.0f).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new float[]{42.0f, 18.0f}), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 18.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"), new Metadata().put("age", 18.0f).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Arrays.asList(Float.valueOf(42.0f), Float.valueOf(18.0f))), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 18.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"), new Metadata().put("age", 18.0f).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new double[]{42.0}), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 42.0).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Collections.singletonList(42.0)), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 42.0).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(new double[]{42.0, 18.0}), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 18.0), new Metadata().put("age", 42.0).put("name", "Klaus"), new Metadata().put("age", 18.0).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isIn(Arrays.asList(42.0, 18.0)), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 18.0), new Metadata().put("age", 42.0).put("name", "Klaus"), new Metadata().put("age", 18.0).put("name", "Klaus")), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Alice")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42)), Arrays.asList(new Metadata().put("name", "Zoe"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Alice"), (Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42), new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42)), Arrays.asList(new Metadata().put("name", "Zoe"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("age", 42), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("name", "Alice").put("age", 666), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus")), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("name", "Alice").put("age", 666), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich"))), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("name", "Klaus").put("city", "Frankfurt"), new Metadata().put("name", "Klaus").put("age", 666).put("city", "Frankfurt"), new Metadata().put("age", 42), new Metadata().put("age", 42).put("country", "Germany"), new Metadata().put("city", "Munich"), new Metadata().put("city", "Munich").put("country", "Germany"), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("city", "Munich").put("country", "Germany"), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("city", "Munich").put("name", "Alice"), new Metadata().put("age", 42).put("city", "Munich").put("name", "Alice"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("city", "Munich").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666), new Metadata().put("name", "Alice").put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666).put("city", "Frankfurt"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("country", "Germany"), new Metadata().put("age", 42), new Metadata().put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("city", "Frankfurt"), new Metadata().put("age", 42).put("city", "Frankfurt"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Frankfurt"), new Metadata().put("city", "Munich"), new Metadata().put("city", "Munich").put("country", "Germany"), new Metadata().put("city", "Munich").put("name", "Alice"), new Metadata().put("city", "Munich").put("age", 666), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("city", "Munich").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666), new Metadata().put("name", "Alice").put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666).put("city", "Frankfurt"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("age", 666).put("name", "Alice"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus")), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich")), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("age", 666).put("name", "Alice"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich"))), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 666).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Frankfurt"), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("city", "Munich").put("name", "Alice"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich")), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Frankfurt"), new Metadata().put("city", "Munich"), new Metadata().put("city", "Munich").put("name", "Klaus"), new Metadata().put("city", "Munich").put("name", "Klaus").put("age", 666), new Metadata().put("city", "Munich").put("age", 42), new Metadata().put("city", "Munich").put("age", 42).put("name", "Alice"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich"))), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("city", "Munich").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("name", "Klaus").put("city", "Frankfurt"), new Metadata().put("age", 42), new Metadata().put("city", "Munich"), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("name", "Alice"), new Metadata().put("city", "Munich").put("name", "Alice"), new Metadata().put("age", 42).put("city", "Munich").put("name", "Alice"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.and((Filter)Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich")), Arrays.asList(new Metadata().put("name", "Klaus").put("city", "Munich"), new Metadata().put("name", "Klaus").put("city", "Munich").put("country", "Germany"), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("city", "Munich").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("age", 42), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("city", "Frankfurt"), new Metadata().put("age", 42).put("city", "Frankfurt"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Frankfurt"), new Metadata().put("city", "Munich"), new Metadata().put("city", "Munich").put("name", "Alice"), new Metadata().put("city", "Munich").put("age", 666), new Metadata().put("city", "Munich").put("name", "Alice").put("age", 666), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich"))), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 666), new Metadata().put("name", "Klaus").put("city", "Frankfurt"), new Metadata().put("name", "Klaus").put("age", 666).put("city", "Frankfurt"), new Metadata().put("age", 42).put("city", "Munich"), new Metadata().put("age", 42).put("city", "Munich").put("country", "Germany"), new Metadata().put("age", 42).put("city", "Munich").put("name", "Alice")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666).put("city", "Frankfurt"), new Metadata())})).add(Arguments.of((Object[])new Object[]{Filter.or((Filter)Filter.and((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus"), (Filter)MetadataFilterBuilder.metadataKey((String)"age").isEqualTo(42)), (Filter)MetadataFilterBuilder.metadataKey((String)"city").isEqualTo("Munich")), Arrays.asList(new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Klaus").put("age", 42).put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Frankfurt"), new Metadata().put("city", "Munich"), new Metadata().put("city", "Munich").put("country", "Germany"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich"), new Metadata().put("name", "Klaus").put("age", 42).put("city", "Munich").put("country", "Germany")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 666), new Metadata().put("city", "Frankfurt"), new Metadata().put("name", "Alice").put("age", 666).put("city", "Frankfurt"), new Metadata())})).build();
    }

    @ParameterizedTest
    @MethodSource
    protected void should_filter_by_metadata_not(Filter metadataFilter, List<Metadata> matchingMetadatas, List<Metadata> notMatchingMetadatas) {
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        for (Metadata matchingMetadata : matchingMetadatas) {
            TextSegment matchingSegment = TextSegment.from((String)"matching", (Metadata)matchingMetadata);
            Embedding matchingEmbedding = (Embedding)this.embeddingModel().embed(matchingSegment).content();
            embeddings.add(matchingEmbedding);
            segments.add(matchingSegment);
        }
        for (Metadata notMatchingMetadata : notMatchingMetadatas) {
            TextSegment notMatchingSegment = TextSegment.from((String)"not matching", (Metadata)notMatchingMetadata);
            Embedding notMatchingEmbedding = (Embedding)this.embeddingModel().embed(notMatchingSegment).content();
            embeddings.add(notMatchingEmbedding);
            segments.add(notMatchingSegment);
        }
        this.embeddingStore().addAll(embeddings, segments);
        TestUtils.awaitUntilAsserted(() -> Assertions.assertThat(this.getAllEmbeddings()).hasSize(embeddings.size()));
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding((Embedding)this.embeddingModel().embed("matching").content()).filter(metadataFilter).maxResults(Integer.valueOf(100)).build();
        List matches = this.embeddingStore().search(embeddingSearchRequest).matches();
        Assertions.assertThat((List)matches).hasSize(matchingMetadatas.size());
        matches.forEach(match -> Assertions.assertThat((String)((TextSegment)match.embedded()).text()).isEqualTo("matching"));
        matches.forEach(match -> Assertions.assertThat((Double)match.score()).isCloseTo(1.0, Percentage.withPercentage((double)0.01)));
    }

    protected static Stream<Arguments> should_filter_by_metadata_not() {
        return Stream.builder().add(Arguments.of((Object[])new Object[]{Filter.not((Filter)MetadataFilterBuilder.metadataKey((String)"name").isEqualTo("Klaus")), Arrays.asList(new Metadata().put("name", "Alice"), new Metadata().put("age", 42), new Metadata()), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo("a"), Arrays.asList(new Metadata().put("key", "A"), new Metadata().put("key", "b"), new Metadata().put("key", "aa"), new Metadata().put("key", "a a"), new Metadata().put("key2", "a"), new Metadata()), Arrays.asList(new Metadata().put("key", "a"), new Metadata().put("key", "a").put("key2", "b"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo(TEST_UUID), Arrays.asList(new Metadata().put("key", UUID.randomUUID()), new Metadata().put("key2", TEST_UUID), new Metadata()), Arrays.asList(new Metadata().put("key", TEST_UUID), new Metadata().put("key", TEST_UUID).put("key2", UUID.randomUUID()))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo(1), Arrays.asList(new Metadata().put("key", -1), new Metadata().put("key", 0), new Metadata().put("key", 2), new Metadata().put("key", 10), new Metadata().put("key2", 1), new Metadata()), Arrays.asList(new Metadata().put("key", 1), new Metadata().put("key", 1).put("key2", 2))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo(1L), Arrays.asList(new Metadata().put("key", -1L), new Metadata().put("key", 0L), new Metadata().put("key", 2L), new Metadata().put("key", 10L), new Metadata().put("key2", 1L), new Metadata()), Arrays.asList(new Metadata().put("key", 1L), new Metadata().put("key", 1L).put("key2", 2L))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo(1.1f), Arrays.asList(new Metadata().put("key", -1.1f), new Metadata().put("key", 0.0f), new Metadata().put("key", 1.11f), new Metadata().put("key", 2.2f), new Metadata().put("key2", 1.1f), new Metadata()), Arrays.asList(new Metadata().put("key", 1.1f), new Metadata().put("key", 1.1f).put("key2", 2.2f))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"key").isNotEqualTo(1.1), Arrays.asList(new Metadata().put("key", -1.1), new Metadata().put("key", 0.0), new Metadata().put("key", 1.11), new Metadata().put("key", 2.2), new Metadata().put("key2", 1.1), new Metadata()), Arrays.asList(new Metadata().put("key", 1.1), new Metadata().put("key", 1.1).put("key2", 2.2))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(new String[]{"Klaus"}), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Alice"), new Metadata().put("name2", "Klaus"), new Metadata()), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(Collections.singletonList("Klaus")), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Alice"), new Metadata().put("name2", "Klaus"), new Metadata()), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(new String[]{"Klaus", "Alice"}), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Zoe"), new Metadata().put("name2", "Klaus"), new Metadata()), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(Arrays.asList("Klaus", "Alice")), Arrays.asList(new Metadata().put("name", "Klaus Heisler"), new Metadata().put("name", "Zoe"), new Metadata().put("name2", "Klaus"), new Metadata()), Arrays.asList(new Metadata().put("name", "Klaus"), new Metadata().put("name", "Klaus").put("age", 42), new Metadata().put("name", "Alice"), new Metadata().put("name", "Alice").put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(new UUID[]{TEST_UUID}), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata()), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(Collections.singletonList(TEST_UUID)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name", TEST_UUID2), new Metadata().put("name2", TEST_UUID), new Metadata()), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(new UUID[]{TEST_UUID, TEST_UUID2}), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata()), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42), new Metadata().put("name", TEST_UUID2), new Metadata().put("name", TEST_UUID2).put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"name").isNotIn(Arrays.asList(TEST_UUID, TEST_UUID2)), Arrays.asList(new Metadata().put("name", UUID.randomUUID()), new Metadata().put("name2", TEST_UUID), new Metadata()), Arrays.asList(new Metadata().put("name", TEST_UUID), new Metadata().put("name", TEST_UUID).put("age", 42), new Metadata().put("name", TEST_UUID2), new Metadata().put("name", TEST_UUID2).put("age", 42))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new int[]{42}), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata()), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Collections.singletonList(42)), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata()), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 42).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new int[]{42, 18}), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata()), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 18), new Metadata().put("age", 42).put("name", "Klaus"), new Metadata().put("age", 18).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Arrays.asList(42, 18)), Arrays.asList(new Metadata().put("age", 666), new Metadata().put("age2", 42), new Metadata()), Arrays.asList(new Metadata().put("age", 42), new Metadata().put("age", 18), new Metadata().put("age", 42).put("name", "Klaus"), new Metadata().put("age", 18).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new long[]{42L}), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata()), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 42L).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Collections.singletonList(42L)), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata()), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 42L).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new long[]{42L, 18L}), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata()), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 18L), new Metadata().put("age", 42L).put("name", "Klaus"), new Metadata().put("age", 18L).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Arrays.asList(42L, 18L)), Arrays.asList(new Metadata().put("age", 666L), new Metadata().put("age2", 42L), new Metadata()), Arrays.asList(new Metadata().put("age", 42L), new Metadata().put("age", 18L), new Metadata().put("age", 42L).put("name", "Klaus"), new Metadata().put("age", 18L).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new float[]{42.0f}), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Collections.singletonList(Float.valueOf(42.0f))), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new float[]{42.0f, 18.0f}), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 18.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"), new Metadata().put("age", 18.0f).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Arrays.asList(Float.valueOf(42.0f), Float.valueOf(18.0f))), Arrays.asList(new Metadata().put("age", 666.0f), new Metadata().put("age2", 42.0f), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0f), new Metadata().put("age", 18.0f), new Metadata().put("age", 42.0f).put("name", "Klaus"), new Metadata().put("age", 18.0f).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new double[]{42.0}), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 42.0).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Collections.singletonList(42.0)), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 42.0).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(new double[]{42.0, 18.0}), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 18.0), new Metadata().put("age", 42.0).put("name", "Klaus"), new Metadata().put("age", 18.0).put("name", "Klaus"))})).add(Arguments.of((Object[])new Object[]{MetadataFilterBuilder.metadataKey((String)"age").isNotIn(Arrays.asList(42.0, 18.0)), Arrays.asList(new Metadata().put("age", 666.0), new Metadata().put("age2", 42.0), new Metadata()), Arrays.asList(new Metadata().put("age", 42.0), new Metadata().put("age", 18.0), new Metadata().put("age", 42.0).put("name", "Klaus"), new Metadata().put("age", 18.0).put("name", "Klaus"))})).build();
    }

    @DisabledIf(value="supportsContains")
    @Test
    protected void should_throw_exception_when_contains_is_not_supported() {
        Filter metadataFilter = MetadataFilterBuilder.metadataKey((String)"key").containsString("value");
        EmbeddingSearchRequest embeddingSearchRequest = EmbeddingSearchRequest.builder().queryEmbedding((Embedding)this.embeddingModel().embed("matching").content()).filter(metadataFilter).maxResults(Integer.valueOf(100)).build();
        Throwable throwable = Assertions.catchThrowable(() -> this.embeddingStore().search(embeddingSearchRequest));
        Assertions.assertThat((Throwable)throwable).isInstanceOf(UnsupportedOperationException.class);
    }

    @EnabledIf(value="supportsContains")
    @Test
    protected void should_filter_by_metadata_contains() {
        this.should_filter_by_metadata(MetadataFilterBuilder.metadataKey((String)"key").containsString("contains"), List.of(new Metadata().put("key", "|contains|"), new Metadata().put("key", "contains").put("key2", "not")), List.of(new Metadata().put("key", "ContainsString"), new Metadata().put("key2", "contains"), new Metadata()));
    }

    @EnabledIf(value="supportsContains")
    @Test
    protected void should_filter_by_not_metadata_contains() {
        this.should_filter_by_metadata_not(Filter.not((Filter)MetadataFilterBuilder.metadataKey((String)"key").containsString("contains")), List.of(new Metadata().put("key", "not"), new Metadata().put("key", "not").put("key2", "contains"), new Metadata()), List.of(new Metadata().put("key", "|contains|"), new Metadata().put("key", "contains").put("key2", "not")));
    }

    protected boolean supportsContains() {
        return false;
    }
}

