/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.EmbeddingSearchRequest;
import dev.langchain4j.store.embedding.EmbeddingSearchResult;
import dev.langchain4j.store.embedding.filter.Filter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface EmbeddingStore<Embedded> {
    public String add(Embedding var1);

    public void add(String var1, Embedding var2);

    public String add(Embedding var1, Embedded var2);

    public List<String> addAll(List<Embedding> var1);

    default public List<String> addAll(List<Embedding> embeddings, List<Embedded> embedded) {
        List<String> ids = this.generateIds(embeddings.size());
        this.addAll(ids, embeddings, embedded);
        return ids;
    }

    default public List<String> generateIds(int n) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            ids.add(Utils.randomUUID());
        }
        return ids;
    }

    default public void addAll(List<String> ids, List<Embedding> embeddings, List<Embedded> embedded) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Experimental
    default public void remove(String id) {
        ValidationUtils.ensureNotBlank(id, "id");
        this.removeAll(Collections.singletonList(id));
    }

    @Experimental
    default public void removeAll(Collection<String> ids) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Experimental
    default public void removeAll(Filter filter) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Experimental
    default public void removeAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public EmbeddingSearchResult<Embedded> search(EmbeddingSearchRequest var1);
}

