/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.video.Video;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class VideoContentTest {
    VideoContentTest() {
    }

    @Test
    void methods() {
        Video urlVideo = Video.builder().url(URI.create("https://example.com/video.mp4")).build();
        VideoContent videoContent = new VideoContent(urlVideo);
        Assertions.assertThat((Object)videoContent.video()).isEqualTo((Object)urlVideo);
        Assertions.assertThat((Comparable)videoContent.type()).isEqualTo((Object)ContentType.VIDEO);
        Assertions.assertThat((Object)videoContent).hasToString("VideoContent { video = Video { url = \"https://example.com/video.mp4\", base64Data = null, mimeType = null } }");
    }

    @Test
    void equals_hash_code() {
        VideoContent v1 = VideoContent.from((String)"https://example.com/video.mp4");
        VideoContent v2 = VideoContent.from((String)"https://example.com/video.mp4");
        VideoContent v3 = VideoContent.from((String)"https://example.com/sound.wav");
        VideoContent v4 = VideoContent.from((String)"https://example.com/sound.wav");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)v1).isEqualTo((Object)v1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)v2)).hasSameHashCodeAs((Object)v2)).isNotEqualTo((Object)v3)).isNotEqualTo((Object)v4);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)v3).isEqualTo((Object)v3)).isEqualTo((Object)v4)).hasSameHashCodeAs((Object)v4);
    }

    @Test
    void builders() {
        Video urlVideo = Video.builder().url(URI.create("https://example.com/video.mp4")).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new VideoContent(urlVideo)).isEqualTo((Object)new VideoContent(urlVideo))).isEqualTo((Object)VideoContent.from((Video)urlVideo))).isEqualTo((Object)VideoContent.from((Video)urlVideo))).isEqualTo((Object)new VideoContent(urlVideo.url()))).isEqualTo((Object)new VideoContent(urlVideo.url().toString()))).isEqualTo((Object)VideoContent.from((URI)urlVideo.url()))).isEqualTo((Object)VideoContent.from((String)urlVideo.url().toString()));
        Video base64video = Video.builder().base64Data("dmlkZW8=").mimeType("mimeType").build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new VideoContent(base64video)).isEqualTo((Object)new VideoContent(base64video))).isEqualTo((Object)VideoContent.from((Video)base64video))).isEqualTo((Object)new VideoContent(base64video.base64Data(), base64video.mimeType()))).isEqualTo((Object)VideoContent.from((String)base64video.base64Data(), (String)base64video.mimeType()));
    }
}

