/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.model.LambdaStreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class LambdaStreamingResponseHandlerTest
implements WithAssertions {
    LambdaStreamingResponseHandlerTest() {
    }

    @Test
    void testOnPartialResponse() {
        ArrayList<Object> tokens = new ArrayList<Object>();
        tokens.add("The sky ");
        tokens.add("is blue because of ");
        tokens.add("a phenomenon called ");
        tokens.add("Rayleigh scattering.");
        DummyModel model = new DummyModel(tokens);
        ArrayList receivedTokens = new ArrayList();
        model.chat("Why is the sky blue?", LambdaStreamingResponseHandler.onPartialResponse(receivedTokens::add));
        this.assertThat(receivedTokens).containsSequence(tokens);
    }

    @Test
    void testOnPartialResponseAndError() {
        ArrayList<Object> tokens = new ArrayList<Object>();
        tokens.add("Three ");
        tokens.add("Two ");
        tokens.add("One ");
        tokens.add(new RuntimeException("BOOM"));
        DummyModel model = new DummyModel(tokens);
        ArrayList receivedTokens = new ArrayList();
        Throwable[] thrown = new Throwable[]{null};
        model.chat("Create a countdown", LambdaStreamingResponseHandler.onPartialResponseAndError(receivedTokens::add, t -> {
            thrown[0] = t;
        }));
        this.assertThat(tokens).containsSubsequence(receivedTokens);
        this.assertThat(thrown[0]).isNotNull();
        this.assertThat(thrown[0]).isInstanceOf(RuntimeException.class);
        this.assertThat(thrown[0].getMessage()).isEqualTo("BOOM");
    }

    static class DummyModel
    implements StreamingChatModel {
        private final List<Object> stringsAndError;

        public DummyModel(List<Object> stringsAndError) {
            this.stringsAndError = stringsAndError;
        }

        public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
            this.stringsAndError.forEach(obj -> {
                if (obj instanceof String) {
                    String message = (String)obj;
                    handler.onPartialResponse(message);
                } else if (obj instanceof Throwable) {
                    Throwable problem = (Throwable)obj;
                    handler.onError(problem);
                }
            });
        }
    }
}

