/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.common;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.common.ChatResponseAndStreamingMetadata;
import dev.langchain4j.model.chat.common.StreamingMetadata;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractBaseChatModelIT<M> {
    static final String CAT_IMAGE_URL = "https://upload.wikimedia.org/wikipedia/commons/e/e9/Felis_silvestris_silvestris_small_gradual_decrease_of_quality.png";
    static final String DICE_IMAGE_URL = "https://upload.wikimedia.org/wikipedia/commons/4/47/PNG_transparency_demonstration_1.png";
    static final ToolSpecification WEATHER_TOOL = ToolSpecification.builder().name("getWeather").parameters(JsonObjectSchema.builder().addStringProperty("city").build()).build();
    static final ResponseFormat RESPONSE_FORMAT = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().name("Answer").rootElement((JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).build()).build();

    protected abstract List<M> models();

    protected List<M> modelsSupportingTools() {
        return this.models();
    }

    protected List<M> modelsSupportingStructuredOutputs() {
        return this.models();
    }

    protected List<M> modelsSupportingImageInputs() {
        return this.models();
    }

    protected String catImageUrl() {
        return CAT_IMAGE_URL;
    }

    protected String diceImageUrl() {
        return DICE_IMAGE_URL;
    }

    protected abstract ChatResponseAndStreamingMetadata chat(M var1, ChatRequest var2);

    @ParameterizedTest
    @MethodSource(value={"models"})
    protected void should_respect_user_message(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        ChatResponseMetadata chatResponseMetadata = chatResponse.metadata();
        if (this.assertChatResponseMetadataType()) {
            Assertions.assertThat((Object)chatResponseMetadata).isExactlyInstanceOf(this.chatResponseMetadataType());
        }
        if (this.assertResponseId()) {
            Assertions.assertThat((String)chatResponseMetadata.id()).isNotBlank();
        }
        if (this.assertResponseModel()) {
            Assertions.assertThat((String)chatResponseMetadata.modelName()).isNotBlank();
        }
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponseMetadata);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponseMetadata.finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    protected void should_respect_system_message(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{SystemMessage.from((String)"Translate messages from user into German"), UserMessage.from((String)"Translate: 'I love you'")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).containsIgnoringCase((CharSequence)"liebe");
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsModelNameParameter")
    protected void should_respect_modelName_in_chat_request(M model) {
        String modelName = this.customModelName();
        this.ensureModelNameIsDifferentFromDefault(modelName, model);
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).maxOutputTokens(Integer.valueOf(1)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isNotBlank();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isEqualTo(modelName);
    }

    protected String customModelName() {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    private void ensureModelNameIsDifferentFromDefault(String modelName, M model) {
        ChatRequest.Builder chatRequestBuilder = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")});
        if (this.supportsMaxOutputTokensParameter()) {
            ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(1)).build();
            chatRequestBuilder.parameters(parameters);
        }
        ChatRequest chatRequest = chatRequestBuilder.build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isNotEqualTo((Object)modelName);
    }

    @Test
    @EnabledIf(value="supportsModelNameParameter")
    protected void should_respect_modelName_in_default_model_parameters() {
        String modelName = this.customModelName();
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).maxOutputTokens(Integer.valueOf(1)).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isNotBlank();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isEqualTo(modelName);
    }

    protected M createModelWith(ChatRequestParameters parameters) {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsModelNameParameter")
    protected void should_fail_if_modelName_is_not_supported(M model) {
        String modelName = "dummy";
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("modelName").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("modelName").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_maxOutputTokens_in_chat_request(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).parameters(parameters).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isLessThanOrEqualTo(maxOutputTokens);
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @Test
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_maxOutputTokens_in_default_model_parameters() {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isLessThanOrEqualTo(maxOutputTokens);
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_fail_if_maxOutputTokens_parameter_is_not_supported(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("maxOutputTokens").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("maxOutputTokens").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsStopSequencesParameter")
    protected void should_respect_stopSequences_in_chat_request(M model) {
        List<String> stopSequences = List.of("World", " World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Hello");
        Assertions.assertThat((String)aiMessage.text()).doesNotContainIgnoringCase(new CharSequence[]{"World"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @Test
    @EnabledIf(value="supportsStopSequencesParameter")
    protected void should_respect_stopSequences_in_default_model_parameters() {
        List<String> stopSequences = List.of("World", " World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Hello");
        Assertions.assertThat((String)aiMessage.text()).doesNotContainIgnoringCase(new CharSequence[]{"World"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsStopSequencesParameter")
    protected void should_fail_if_stopSequences_parameter_is_not_supported(M model) {
        List<String> stopSequences = List.of("World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("stopSequences").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("stopSequences").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_common_parameters_wrapped_in_integration_specific_class_in_chat_request(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = this.createIntegrationSpecificParameters(maxOutputTokens);
        Assertions.assertThat((Object)parameters).doesNotHaveSameClassAs(DefaultChatRequestParameters.class);
        ChatRequest chatRequest = ChatRequest.builder().parameters(parameters).messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
    }

    @Test
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_common_parameters_wrapped_in_integration_specific_class_in_default_model_parameters() {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = this.createIntegrationSpecificParameters(maxOutputTokens);
        Assertions.assertThat((Object)parameters).doesNotHaveSameClassAs(DefaultChatRequestParameters.class);
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().parameters(parameters).messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
    }

    protected ChatRequestParameters createIntegrationSpecificParameters(int maxOutputTokens) {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsTools")
    protected void should_execute_a_tool_then_answer(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the weather in Munich?");
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (streamingMetadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)"sunny")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).contains(new CharSequence[]{"sun"});
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            if (this.assertTimesOnPartialResponseWasCalled()) {
                Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            }
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsTools")
    protected void should_fail_if_tools_are_not_supported(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the weather in Munich?")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("tool").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolChoiceRequiredWithMultipleTools")
    protected void should_force_LLM_to_execute_any_tool(M model) {
        ToolSpecification calculatorTool = ToolSpecification.builder().name("add_two_numbers").parameters(JsonObjectSchema.builder().addIntegerProperty("a").addIntegerProperty("b").build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL, calculatorTool}).toolChoice(ToolChoice.REQUIRED).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolChoiceRequiredWithSingleTool")
    protected void should_force_LLM_to_execute_specific_tool(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).toolChoice(ToolChoice.REQUIRED).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @DisabledIf(value="supportsToolChoiceRequired")
    protected void should_fail_if_tool_choice_REQUIRED_is_not_supported(M model) {
        ToolChoice toolChoice = ToolChoice.REQUIRED;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).toolChoice(toolChoice).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("ToolChoice.REQUIRED").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingStructuredOutputs"})
    @EnabledIf(value="supportsJsonResponseFormat")
    protected void should_respect_JSON_response_format(M model) {
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany? Answer with a JSON object containing a single 'city' field")}).parameters(ChatRequestParameters.builder().responseFormat(responseFormat).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\": \"Berlin\"}");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormat")
    protected void should_fail_if_JSON_response_format_is_not_supported(M model) {
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany? Answer with a JSON object containing a single 'city' field")}).parameters(ChatRequestParameters.builder().responseFormat(responseFormat).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("JSON response format").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingStructuredOutputs"})
    @EnabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_respect_JSON_response_format_with_schema(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).parameters(ChatRequestParameters.builder().responseFormat(RESPONSE_FORMAT).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\": \"Berlin\"}");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_fail_if_JSON_response_format_with_schema_is_not_supported(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).parameters(ChatRequestParameters.builder().responseFormat(RESPONSE_FORMAT).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("JSON response format").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolsAndJsonResponseFormatWithSchema")
    protected void should_execute_a_tool_then_answer_respecting_JSON_response_format_with_schema(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the weather in Munich?");
        ResponseFormat responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().name("weather").rootElement((JsonSchemaElement)JsonObjectSchema.builder().addEnumProperty("weather", List.of("sunny", "rainy")).build()).build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).responseFormat(responseFormat).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (streamingMetadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)"sunny")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).responseFormat(responseFormat).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"weather\":\"sunny\"}");
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsBase64EncodedString")
    protected void should_accept_single_image_as_base64_encoded_string(M model) {
        String base64Data = Base64.getEncoder().encodeToString(Utils.readBytes((String)this.catImageUrl()));
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)base64Data, (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"cat");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsMultipleImageInputsAsBase64EncodedStrings")
    protected void should_accept_multiple_images_as_base64_encoded_strings(M model) {
        Base64.Encoder encoder = Base64.getEncoder();
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see on these images?"), ImageContent.from((String)encoder.encodeToString(Utils.readBytes((String)this.catImageUrl())), (String)"image/png"), ImageContent.from((String)encoder.encodeToString(Utils.readBytes((String)this.diceImageUrl())), (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"cat")).containsIgnoringCase((CharSequence)"dice");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @DisabledIf(value="supportsSingleImageInputAsBase64EncodedString")
    protected void should_fail_if_images_as_base64_encoded_strings_are_not_supported(M model) {
        String base64Data = Base64.getEncoder().encodeToString(Utils.readBytes((String)this.catImageUrl()));
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)base64Data, (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("image").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_accept_single_image_as_public_URL(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)this.catImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"cat");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsMultipleImageInputsAsPublicURLs")
    protected void should_accept_multiple_images_as_public_URLs(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see on these images?"), ImageContent.from((String)this.catImageUrl()), ImageContent.from((String)this.diceImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"cat")).containsIgnoringCase((CharSequence)"dice");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata());
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @DisabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_fail_if_images_as_public_URLs_are_not_supported(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)this.catImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("image").hasMessageContaining("not support");
        }
    }

    protected boolean supportsDefaultRequestParameters() {
        return true;
    }

    protected boolean supportsModelNameParameter() {
        return true;
    }

    protected boolean supportsMaxOutputTokensParameter() {
        return true;
    }

    protected boolean supportsStopSequencesParameter() {
        return true;
    }

    protected boolean supportsTools() {
        return true;
    }

    protected boolean supportsToolChoiceRequired() {
        return true;
    }

    protected boolean supportsToolChoiceRequiredWithSingleTool() {
        return this.supportsToolChoiceRequired();
    }

    protected boolean supportsToolChoiceRequiredWithMultipleTools() {
        return this.supportsToolChoiceRequired();
    }

    protected boolean supportsJsonResponseFormat() {
        return true;
    }

    protected boolean supportsJsonResponseFormatWithSchema() {
        return true;
    }

    protected boolean supportsToolsAndJsonResponseFormatWithSchema() {
        return this.supportsTools() && this.supportsJsonResponseFormatWithSchema();
    }

    protected boolean supportsSingleImageInputAsBase64EncodedString() {
        return true;
    }

    protected boolean supportsMultipleImageInputsAsBase64EncodedStrings() {
        return this.supportsSingleImageInputAsBase64EncodedString();
    }

    protected boolean supportsSingleImageInputAsPublicURL() {
        return true;
    }

    protected boolean supportsMultipleImageInputsAsPublicURLs() {
        return this.supportsSingleImageInputAsPublicURL();
    }

    protected boolean assertChatResponseMetadataType() {
        return true;
    }

    protected Class<? extends ChatResponseMetadata> chatResponseMetadataType() {
        return ChatResponseMetadata.class;
    }

    protected boolean assertResponseId() {
        return true;
    }

    protected boolean assertResponseModel() {
        return true;
    }

    protected boolean assertTokenUsage() {
        return true;
    }

    protected boolean assertFinishReason() {
        return true;
    }

    protected boolean assertThreads() {
        return true;
    }

    protected boolean assertExceptionType() {
        return true;
    }

    protected boolean assertTimesOnPartialResponseWasCalled() {
        return true;
    }

    void assertTokenUsage(ChatResponseMetadata chatResponseMetadata) {
        this.assertTokenUsage(chatResponseMetadata, null);
    }

    void assertTokenUsage(ChatResponseMetadata chatResponseMetadata, Integer maxOutputTokens) {
        TokenUsage tokenUsage = chatResponseMetadata.tokenUsage();
        Assertions.assertThat((Object)tokenUsage).isExactlyInstanceOf(this.tokenUsageType());
        Assertions.assertThat((Integer)tokenUsage.inputTokenCount()).isPositive();
        if (maxOutputTokens != null) {
            Assertions.assertThat((Integer)tokenUsage.outputTokenCount()).isEqualTo((Object)maxOutputTokens);
        }
        Assertions.assertThat((Integer)tokenUsage.totalTokenCount()).isEqualTo(tokenUsage.inputTokenCount() + tokenUsage.outputTokenCount());
    }

    protected Class<? extends TokenUsage> tokenUsageType() {
        return TokenUsage.class;
    }
}

